/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=AccessRoleSerializer.class)
public class AccessRole {
    public static final AccessRole STANDARD = new AccessRole("st");
    public static final AccessRole ADMIN = new AccessRole("adm");
    public static final AccessRole READ_ONLY = new AccessRole("ro");
    public static final AccessRole ERROR = new AccessRole("ERROR");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("st", "adm", "ro", "ERROR"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    AccessRole(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((AccessRole)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AccessRole fromValue(String value) {
        return new AccessRole(value);
    }

    public static class AccessRoleSerializer
    extends StdSerializer<AccessRole> {
        public AccessRoleSerializer(Class<AccessRole> t) {
            super(t);
        }

        public AccessRoleSerializer() {
            this(null);
        }

        public void serialize(AccessRole value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

