/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.HTTPTokenAuth;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=HTTPCredentialsDeserializer.class)
@JsonSerialize(using=HTTPCredentialsSerializer.class)
public class HTTPCredentials
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(HTTPCredentials.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public HTTPCredentials() {
        super("oneOf", Boolean.FALSE);
    }

    public HTTPCredentials(HTTPTokenAuth o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(HTTPTokenAuth.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be HTTPTokenAuth");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public HTTPTokenAuth getHTTPTokenAuth() throws ClassCastException {
        return (HTTPTokenAuth)super.getActualInstance();
    }

    static {
        schemas.put("HTTPTokenAuth", (GenericType)new GenericType<HTTPTokenAuth>(){});
        JSON.registerDescendants(HTTPCredentials.class, Collections.unmodifiableMap(schemas));
    }

    public static class HTTPCredentialsDeserializer
    extends StdDeserializer<HTTPCredentials> {
        public HTTPCredentialsDeserializer() {
            this(HTTPCredentials.class);
        }

        public HTTPCredentialsDeserializer(Class<?> vc) {
            super(vc);
        }

        public HTTPCredentials deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((HTTPTokenAuth.class.equals(Integer.class) || HTTPTokenAuth.class.equals(Long.class) || HTTPTokenAuth.class.equals(Float.class) || HTTPTokenAuth.class.equals(Double.class) || HTTPTokenAuth.class.equals(Boolean.class) || HTTPTokenAuth.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (HTTPTokenAuth.class.equals(Integer.class) || HTTPTokenAuth.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!HTTPTokenAuth.class.equals(Float.class) && !HTTPTokenAuth.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= HTTPTokenAuth.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= HTTPTokenAuth.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(HTTPTokenAuth.class);
                    if (!((HTTPTokenAuth)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'HTTPTokenAuth'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'HTTPTokenAuth'", e);
            }
            HTTPCredentials ret = new HTTPCredentials();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map res = (Map)new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        public HTTPCredentials getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "HTTPCredentials cannot be null");
        }
    }

    public static class HTTPCredentialsSerializer
    extends StdSerializer<HTTPCredentials> {
        public HTTPCredentialsSerializer(Class<HTTPCredentials> t) {
            super(t);
        }

        public HTTPCredentialsSerializer() {
            this(null);
        }

        public void serialize(HTTPCredentials value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

