/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentPoliciesListResponse;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentPolicyCreateRequest;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentPolicyResponse;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentPolicyUpdateRequest;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRuleCreateRequest;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRuleResponse;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRuleUpdateRequest;
import com.datadog.api.client.v2.model.CloudWorkloadSecurityAgentRulesListResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CsmThreatsApi {
    private ApiClient apiClient;

    public CsmThreatsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CsmThreatsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CloudWorkloadSecurityAgentRuleResponse createCloudWorkloadSecurityAgentRule(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        return this.createCloudWorkloadSecurityAgentRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> createCloudWorkloadSecurityAgentRuleAsync(CloudWorkloadSecurityAgentRuleCreateRequest body) {
        return this.createCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(body).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> createCloudWorkloadSecurityAgentRuleWithHttpInfo(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.createCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> createCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(CloudWorkloadSecurityAgentRuleCreateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.createCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CloudWorkloadSecurityAgentPolicyResponse createCSMThreatsAgentPolicy(CloudWorkloadSecurityAgentPolicyCreateRequest body) throws ApiException {
        return this.createCSMThreatsAgentPolicyWithHttpInfo(body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentPolicyResponse> createCSMThreatsAgentPolicyAsync(CloudWorkloadSecurityAgentPolicyCreateRequest body) {
        return this.createCSMThreatsAgentPolicyWithHttpInfoAsync(body).thenApply(response -> (CloudWorkloadSecurityAgentPolicyResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentPolicyResponse> createCSMThreatsAgentPolicyWithHttpInfo(CloudWorkloadSecurityAgentPolicyCreateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCSMThreatsAgentPolicy");
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.createCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> createCSMThreatsAgentPolicyWithHttpInfoAsync(CloudWorkloadSecurityAgentPolicyCreateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCSMThreatsAgentPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.createCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPolicyResponse>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse createCSMThreatsAgentRule(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        return this.createCSMThreatsAgentRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> createCSMThreatsAgentRuleAsync(CloudWorkloadSecurityAgentRuleCreateRequest body) {
        return this.createCSMThreatsAgentRuleWithHttpInfoAsync(body).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> createCSMThreatsAgentRuleWithHttpInfo(CloudWorkloadSecurityAgentRuleCreateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCSMThreatsAgentRule");
        }
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.createCSMThreatsAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> createCSMThreatsAgentRuleWithHttpInfoAsync(CloudWorkloadSecurityAgentRuleCreateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentRuleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCSMThreatsAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.createCSMThreatsAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public void deleteCloudWorkloadSecurityAgentRule(String agentRuleId) throws ApiException {
        this.deleteCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId);
    }

    public CompletableFuture<Void> deleteCloudWorkloadSecurityAgentRuleAsync(String agentRuleId) {
        return this.deleteCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(agentRuleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.deleteCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(String agentRuleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.deleteCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCSMThreatsAgentPolicy(String policyId) throws ApiException {
        this.deleteCSMThreatsAgentPolicyWithHttpInfo(policyId);
    }

    public CompletableFuture<Void> deleteCSMThreatsAgentPolicyAsync(String policyId) {
        return this.deleteCSMThreatsAgentPolicyWithHttpInfoAsync(policyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCSMThreatsAgentPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteCSMThreatsAgentPolicy");
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.deleteCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCSMThreatsAgentPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling deleteCSMThreatsAgentPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.deleteCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCSMThreatsAgentRule(String agentRuleId) throws ApiException {
        this.deleteCSMThreatsAgentRuleWithHttpInfo(agentRuleId, new DeleteCSMThreatsAgentRuleOptionalParameters());
    }

    public CompletableFuture<Void> deleteCSMThreatsAgentRuleAsync(String agentRuleId) {
        return this.deleteCSMThreatsAgentRuleWithHttpInfoAsync(agentRuleId, new DeleteCSMThreatsAgentRuleOptionalParameters()).thenApply(response -> (Void)response.getData());
    }

    public void deleteCSMThreatsAgentRule(String agentRuleId, DeleteCSMThreatsAgentRuleOptionalParameters parameters) throws ApiException {
        this.deleteCSMThreatsAgentRuleWithHttpInfo(agentRuleId, parameters);
    }

    public CompletableFuture<Void> deleteCSMThreatsAgentRuleAsync(String agentRuleId, DeleteCSMThreatsAgentRuleOptionalParameters parameters) {
        return this.deleteCSMThreatsAgentRuleWithHttpInfoAsync(agentRuleId, parameters).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCSMThreatsAgentRuleWithHttpInfo(String agentRuleId, DeleteCSMThreatsAgentRuleOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCSMThreatsAgentRule");
        }
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.deleteCSMThreatsAgentRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCSMThreatsAgentRuleWithHttpInfoAsync(String agentRuleId, DeleteCSMThreatsAgentRuleOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling deleteCSMThreatsAgentRule"));
            return result;
        }
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.deleteCSMThreatsAgentRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public File downloadCloudWorkloadPolicyFile() throws ApiException {
        return this.downloadCloudWorkloadPolicyFileWithHttpInfo().getData();
    }

    public CompletableFuture<File> downloadCloudWorkloadPolicyFileAsync() {
        return this.downloadCloudWorkloadPolicyFileWithHttpInfoAsync().thenApply(response -> (File)response.getData());
    }

    public ApiResponse<File> downloadCloudWorkloadPolicyFileWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/cloud_workload/policy/download";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.downloadCloudWorkloadPolicyFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/yaml", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public CompletableFuture<ApiResponse<File>> downloadCloudWorkloadPolicyFileWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/cloud_workload/policy/download";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.downloadCloudWorkloadPolicyFile", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/yaml", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<File>> result = new CompletableFuture<ApiResponse<File>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public File downloadCSMThreatsPolicy() throws ApiException {
        return this.downloadCSMThreatsPolicyWithHttpInfo().getData();
    }

    public CompletableFuture<File> downloadCSMThreatsPolicyAsync() {
        return this.downloadCSMThreatsPolicyWithHttpInfoAsync().thenApply(response -> (File)response.getData());
    }

    public ApiResponse<File> downloadCSMThreatsPolicyWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/cws/policy/download";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.downloadCSMThreatsPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/zip", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public CompletableFuture<ApiResponse<File>> downloadCSMThreatsPolicyWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/cws/policy/download";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.downloadCSMThreatsPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/zip", "application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<File>> result = new CompletableFuture<ApiResponse<File>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse getCloudWorkloadSecurityAgentRule(String agentRuleId) throws ApiException {
        return this.getCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> getCloudWorkloadSecurityAgentRuleAsync(String agentRuleId) {
        return this.getCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(agentRuleId).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> getCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.getCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> getCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(String agentRuleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.getCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CloudWorkloadSecurityAgentPolicyResponse getCSMThreatsAgentPolicy(String policyId) throws ApiException {
        return this.getCSMThreatsAgentPolicyWithHttpInfo(policyId).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentPolicyResponse> getCSMThreatsAgentPolicyAsync(String policyId) {
        return this.getCSMThreatsAgentPolicyWithHttpInfoAsync(policyId).thenApply(response -> (CloudWorkloadSecurityAgentPolicyResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentPolicyResponse> getCSMThreatsAgentPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getCSMThreatsAgentPolicy");
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.getCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> getCSMThreatsAgentPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling getCSMThreatsAgentPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.getCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPolicyResponse>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse getCSMThreatsAgentRule(String agentRuleId) throws ApiException {
        return this.getCSMThreatsAgentRuleWithHttpInfo(agentRuleId, new GetCSMThreatsAgentRuleOptionalParameters()).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> getCSMThreatsAgentRuleAsync(String agentRuleId) {
        return this.getCSMThreatsAgentRuleWithHttpInfoAsync(agentRuleId, new GetCSMThreatsAgentRuleOptionalParameters()).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public CloudWorkloadSecurityAgentRuleResponse getCSMThreatsAgentRule(String agentRuleId, GetCSMThreatsAgentRuleOptionalParameters parameters) throws ApiException {
        return this.getCSMThreatsAgentRuleWithHttpInfo(agentRuleId, parameters).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> getCSMThreatsAgentRuleAsync(String agentRuleId, GetCSMThreatsAgentRuleOptionalParameters parameters) {
        return this.getCSMThreatsAgentRuleWithHttpInfoAsync(agentRuleId, parameters).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> getCSMThreatsAgentRuleWithHttpInfo(String agentRuleId, GetCSMThreatsAgentRuleOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCSMThreatsAgentRule");
        }
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.getCSMThreatsAgentRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> getCSMThreatsAgentRuleWithHttpInfoAsync(String agentRuleId, GetCSMThreatsAgentRuleOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling getCSMThreatsAgentRule"));
            return result;
        }
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.getCSMThreatsAgentRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CloudWorkloadSecurityAgentRulesListResponse listCloudWorkloadSecurityAgentRules() throws ApiException {
        return this.listCloudWorkloadSecurityAgentRulesWithHttpInfo().getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRulesListResponse> listCloudWorkloadSecurityAgentRulesAsync() {
        return this.listCloudWorkloadSecurityAgentRulesWithHttpInfoAsync().thenApply(response -> (CloudWorkloadSecurityAgentRulesListResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRulesListResponse> listCloudWorkloadSecurityAgentRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.listCloudWorkloadSecurityAgentRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>> listCloudWorkloadSecurityAgentRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.listCloudWorkloadSecurityAgentRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){});
    }

    public CloudWorkloadSecurityAgentPoliciesListResponse listCSMThreatsAgentPolicies() throws ApiException {
        return this.listCSMThreatsAgentPoliciesWithHttpInfo().getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentPoliciesListResponse> listCSMThreatsAgentPoliciesAsync() {
        return this.listCSMThreatsAgentPoliciesWithHttpInfoAsync().thenApply(response -> (CloudWorkloadSecurityAgentPoliciesListResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentPoliciesListResponse> listCSMThreatsAgentPoliciesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/cws/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.listCSMThreatsAgentPolicies", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPoliciesListResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPoliciesListResponse>> listCSMThreatsAgentPoliciesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/remote_config/products/cws/policy";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.listCSMThreatsAgentPolicies", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPoliciesListResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPoliciesListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPoliciesListResponse>(){});
    }

    public CloudWorkloadSecurityAgentRulesListResponse listCSMThreatsAgentRules() throws ApiException {
        return this.listCSMThreatsAgentRulesWithHttpInfo(new ListCSMThreatsAgentRulesOptionalParameters()).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRulesListResponse> listCSMThreatsAgentRulesAsync() {
        return this.listCSMThreatsAgentRulesWithHttpInfoAsync(new ListCSMThreatsAgentRulesOptionalParameters()).thenApply(response -> (CloudWorkloadSecurityAgentRulesListResponse)response.getData());
    }

    public CloudWorkloadSecurityAgentRulesListResponse listCSMThreatsAgentRules(ListCSMThreatsAgentRulesOptionalParameters parameters) throws ApiException {
        return this.listCSMThreatsAgentRulesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRulesListResponse> listCSMThreatsAgentRulesAsync(ListCSMThreatsAgentRulesOptionalParameters parameters) {
        return this.listCSMThreatsAgentRulesWithHttpInfoAsync(parameters).thenApply(response -> (CloudWorkloadSecurityAgentRulesListResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRulesListResponse> listCSMThreatsAgentRulesWithHttpInfo(ListCSMThreatsAgentRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.listCSMThreatsAgentRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>> listCSMThreatsAgentRulesWithHttpInfoAsync(ListCSMThreatsAgentRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.listCSMThreatsAgentRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRulesListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRulesListResponse>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse updateCloudWorkloadSecurityAgentRule(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        return this.updateCloudWorkloadSecurityAgentRuleWithHttpInfo(agentRuleId, body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> updateCloudWorkloadSecurityAgentRuleAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) {
        return this.updateCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(agentRuleId, body).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> updateCloudWorkloadSecurityAgentRuleWithHttpInfo(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCloudWorkloadSecurityAgentRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCloudWorkloadSecurityAgentRule");
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.updateCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> updateCloudWorkloadSecurityAgentRuleWithHttpInfoAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCloudWorkloadSecurityAgentRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCloudWorkloadSecurityAgentRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/cloud_workload_security/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.updateCloudWorkloadSecurityAgentRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CloudWorkloadSecurityAgentPolicyResponse updateCSMThreatsAgentPolicy(String policyId, CloudWorkloadSecurityAgentPolicyUpdateRequest body) throws ApiException {
        return this.updateCSMThreatsAgentPolicyWithHttpInfo(policyId, body).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentPolicyResponse> updateCSMThreatsAgentPolicyAsync(String policyId, CloudWorkloadSecurityAgentPolicyUpdateRequest body) {
        return this.updateCSMThreatsAgentPolicyWithHttpInfoAsync(policyId, body).thenApply(response -> (CloudWorkloadSecurityAgentPolicyResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentPolicyResponse> updateCSMThreatsAgentPolicyWithHttpInfo(String policyId, CloudWorkloadSecurityAgentPolicyUpdateRequest body) throws ApiException {
        CloudWorkloadSecurityAgentPolicyUpdateRequest localVarPostBody = body;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling updateCSMThreatsAgentPolicy");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCSMThreatsAgentPolicy");
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.updateCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> updateCSMThreatsAgentPolicyWithHttpInfoAsync(String policyId, CloudWorkloadSecurityAgentPolicyUpdateRequest body) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentPolicyUpdateRequest localVarPostBody = body;
        if (policyId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling updateCSMThreatsAgentPolicy"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCSMThreatsAgentPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/remote_config/products/cws/policy/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.updateCSMThreatsAgentPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentPolicyResponse>(){});
    }

    public CloudWorkloadSecurityAgentRuleResponse updateCSMThreatsAgentRule(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) throws ApiException {
        return this.updateCSMThreatsAgentRuleWithHttpInfo(agentRuleId, body, new UpdateCSMThreatsAgentRuleOptionalParameters()).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> updateCSMThreatsAgentRuleAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body) {
        return this.updateCSMThreatsAgentRuleWithHttpInfoAsync(agentRuleId, body, new UpdateCSMThreatsAgentRuleOptionalParameters()).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public CloudWorkloadSecurityAgentRuleResponse updateCSMThreatsAgentRule(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body, UpdateCSMThreatsAgentRuleOptionalParameters parameters) throws ApiException {
        return this.updateCSMThreatsAgentRuleWithHttpInfo(agentRuleId, body, parameters).getData();
    }

    public CompletableFuture<CloudWorkloadSecurityAgentRuleResponse> updateCSMThreatsAgentRuleAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body, UpdateCSMThreatsAgentRuleOptionalParameters parameters) {
        return this.updateCSMThreatsAgentRuleWithHttpInfoAsync(agentRuleId, body, parameters).thenApply(response -> (CloudWorkloadSecurityAgentRuleResponse)response.getData());
    }

    public ApiResponse<CloudWorkloadSecurityAgentRuleResponse> updateCSMThreatsAgentRuleWithHttpInfo(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body, UpdateCSMThreatsAgentRuleOptionalParameters parameters) throws ApiException {
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCSMThreatsAgentRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCSMThreatsAgentRule");
        }
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CsmThreatsApi.updateCSMThreatsAgentRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> updateCSMThreatsAgentRuleWithHttpInfoAsync(String agentRuleId, CloudWorkloadSecurityAgentRuleUpdateRequest body, UpdateCSMThreatsAgentRuleOptionalParameters parameters) {
        Invocation.Builder builder;
        CloudWorkloadSecurityAgentRuleUpdateRequest localVarPostBody = body;
        if (agentRuleId == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentRuleId' when calling updateCSMThreatsAgentRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCSMThreatsAgentRule"));
            return result;
        }
        String policyId = parameters.policyId;
        String localVarPath = "/api/v2/remote_config/products/cws/agent_rules/{agent_rule_id}".replaceAll("\\{agent_rule_id\\}", this.apiClient.escapeString(agentRuleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "policy_id", policyId));
        try {
            builder = this.apiClient.createBuilder("v2.CsmThreatsApi.updateCSMThreatsAgentRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>> result = new CompletableFuture<ApiResponse<CloudWorkloadSecurityAgentRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudWorkloadSecurityAgentRuleResponse>(){});
    }

    public static class UpdateCSMThreatsAgentRuleOptionalParameters {
        private String policyId;

        public UpdateCSMThreatsAgentRuleOptionalParameters policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }
    }

    public static class ListCSMThreatsAgentRulesOptionalParameters {
        private String policyId;

        public ListCSMThreatsAgentRulesOptionalParameters policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }
    }

    public static class GetCSMThreatsAgentRuleOptionalParameters {
        private String policyId;

        public GetCSMThreatsAgentRuleOptionalParameters policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }
    }

    public static class DeleteCSMThreatsAgentRuleOptionalParameters {
        private String policyId;

        public DeleteCSMThreatsAgentRuleOptionalParameters policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }
    }
}

