/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EntityData;
import com.datadog.api.client.v2.model.EntityResponseMeta;
import com.datadog.api.client.v2.model.UpsertCatalogEntityResponseIncludedItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "included", "meta"})
public class UpsertCatalogEntityResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<EntityData> data = null;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<UpsertCatalogEntityResponseIncludedItem> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private EntityResponseMeta meta;
    private Map<String, Object> additionalProperties;

    public UpsertCatalogEntityResponse data(List<EntityData> data) {
        this.data = data;
        for (EntityData item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UpsertCatalogEntityResponse addDataItem(EntityData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<EntityData>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityData> getData() {
        return this.data;
    }

    public void setData(List<EntityData> data) {
        this.data = data;
    }

    public UpsertCatalogEntityResponse included(List<UpsertCatalogEntityResponseIncludedItem> included) {
        this.included = included;
        for (UpsertCatalogEntityResponseIncludedItem item : included) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UpsertCatalogEntityResponse addIncludedItem(UpsertCatalogEntityResponseIncludedItem includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<UpsertCatalogEntityResponseIncludedItem>();
        }
        this.included.add(includedItem);
        this.unparsed |= includedItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UpsertCatalogEntityResponseIncludedItem> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<UpsertCatalogEntityResponseIncludedItem> included) {
        this.included = included;
    }

    public UpsertCatalogEntityResponse meta(EntityResponseMeta meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityResponseMeta getMeta() {
        return this.meta;
    }

    public void setMeta(EntityResponseMeta meta) {
        this.meta = meta;
    }

    @JsonAnySetter
    public UpsertCatalogEntityResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertCatalogEntityResponse upsertCatalogEntityResponse = (UpsertCatalogEntityResponse)o;
        return Objects.equals(this.data, upsertCatalogEntityResponse.data) && Objects.equals(this.included, upsertCatalogEntityResponse.included) && Objects.equals(this.meta, upsertCatalogEntityResponse.meta) && Objects.equals(this.additionalProperties, upsertCatalogEntityResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertCatalogEntityResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

