/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.DataScalarColumn;
import com.datadog.api.client.v2.model.GroupScalarColumn;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=ScalarColumnDeserializer.class)
@JsonSerialize(using=ScalarColumnSerializer.class)
public class ScalarColumn
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ScalarColumn.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public ScalarColumn() {
        super("oneOf", Boolean.FALSE);
    }

    public ScalarColumn(GroupScalarColumn o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ScalarColumn(DataScalarColumn o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(GroupScalarColumn.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(DataScalarColumn.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be GroupScalarColumn, DataScalarColumn");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public GroupScalarColumn getGroupScalarColumn() throws ClassCastException {
        return (GroupScalarColumn)super.getActualInstance();
    }

    public DataScalarColumn getDataScalarColumn() throws ClassCastException {
        return (DataScalarColumn)super.getActualInstance();
    }

    static {
        schemas.put("GroupScalarColumn", (GenericType)new GenericType<GroupScalarColumn>(){});
        schemas.put("DataScalarColumn", (GenericType)new GenericType<DataScalarColumn>(){});
        JSON.registerDescendants(ScalarColumn.class, Collections.unmodifiableMap(schemas));
    }

    public static class ScalarColumnDeserializer
    extends StdDeserializer<ScalarColumn> {
        public ScalarColumnDeserializer() {
            this(ScalarColumn.class);
        }

        public ScalarColumnDeserializer(Class<?> vc) {
            super(vc);
        }

        public ScalarColumn deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((GroupScalarColumn.class.equals(Integer.class) || GroupScalarColumn.class.equals(Long.class) || GroupScalarColumn.class.equals(Float.class) || GroupScalarColumn.class.equals(Double.class) || GroupScalarColumn.class.equals(Boolean.class) || GroupScalarColumn.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (GroupScalarColumn.class.equals(Integer.class) || GroupScalarColumn.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!GroupScalarColumn.class.equals(Float.class) && !GroupScalarColumn.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= GroupScalarColumn.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= GroupScalarColumn.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(GroupScalarColumn.class);
                    if (!((GroupScalarColumn)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'GroupScalarColumn'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'GroupScalarColumn'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((DataScalarColumn.class.equals(Integer.class) || DataScalarColumn.class.equals(Long.class) || DataScalarColumn.class.equals(Float.class) || DataScalarColumn.class.equals(Double.class) || DataScalarColumn.class.equals(Boolean.class) || DataScalarColumn.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (DataScalarColumn.class.equals(Integer.class) || DataScalarColumn.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!DataScalarColumn.class.equals(Float.class) && !DataScalarColumn.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= DataScalarColumn.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= DataScalarColumn.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(DataScalarColumn.class);
                    if (!((DataScalarColumn)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'DataScalarColumn'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'DataScalarColumn'", e);
            }
            ScalarColumn ret = new ScalarColumn();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map res = (Map)new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        public ScalarColumn getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "ScalarColumn cannot be null");
        }
    }

    public static class ScalarColumnSerializer
    extends StdSerializer<ScalarColumn> {
        public ScalarColumnSerializer(Class<ScalarColumn> t) {
            super(t);
        }

        public ScalarColumnSerializer() {
            this(null);
        }

        public void serialize(ScalarColumn value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

