/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.VulnerabilitySeverity;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"score", "severity"})
public class EPSS {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_SCORE = "score";
    private Double score;
    public static final String JSON_PROPERTY_SEVERITY = "severity";
    private VulnerabilitySeverity severity;
    private Map<String, Object> additionalProperties;

    public EPSS() {
    }

    @JsonCreator
    public EPSS(@JsonProperty(required=true, value="score") Double score, @JsonProperty(required=true, value="severity") VulnerabilitySeverity severity) {
        this.score = score;
        this.severity = severity;
        this.unparsed |= !severity.isValid();
    }

    public EPSS score(Double score) {
        this.score = score;
        return this;
    }

    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public EPSS severity(VulnerabilitySeverity severity) {
        this.severity = severity;
        this.unparsed |= !severity.isValid();
        return this;
    }

    @JsonProperty(value="severity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilitySeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(VulnerabilitySeverity severity) {
        if (!severity.isValid()) {
            this.unparsed = true;
        }
        this.severity = severity;
    }

    @JsonAnySetter
    public EPSS putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EPSS epss = (EPSS)o;
        return Objects.equals(this.score, epss.score) && Objects.equals(this.severity, epss.severity) && Objects.equals(this.additionalProperties, epss.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.severity, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EPSS {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

