/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SBOMComponentType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"bom-ref", "name", "purl", "type", "version"})
public class SBOMComponent {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BOM_REF = "bom-ref";
    private String bomRef;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PURL = "purl";
    private String purl;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SBOMComponentType type;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    private Map<String, Object> additionalProperties;

    public SBOMComponent() {
    }

    @JsonCreator
    public SBOMComponent(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="type") SBOMComponentType type, @JsonProperty(required=true, value="version") String version) {
        this.name = name;
        this.type = type;
        this.unparsed |= !type.isValid();
        this.version = version;
    }

    public SBOMComponent bomRef(String bomRef) {
        this.bomRef = bomRef;
        return this;
    }

    @Nullable
    @JsonProperty(value="bom-ref")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public SBOMComponent name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SBOMComponent purl(String purl) {
        this.purl = purl;
        return this;
    }

    @Nullable
    @JsonProperty(value="purl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPurl() {
        return this.purl;
    }

    public void setPurl(String purl) {
        this.purl = purl;
    }

    public SBOMComponent type(SBOMComponentType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SBOMComponentType getType() {
        return this.type;
    }

    public void setType(SBOMComponentType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public SBOMComponent version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonAnySetter
    public SBOMComponent putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SBOMComponent sbomComponent = (SBOMComponent)o;
        return Objects.equals(this.bomRef, sbomComponent.bomRef) && Objects.equals(this.name, sbomComponent.name) && Objects.equals(this.purl, sbomComponent.purl) && Objects.equals(this.type, sbomComponent.type) && Objects.equals(this.version, sbomComponent.version) && Objects.equals(this.additionalProperties, sbomComponent.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bomRef, this.name, this.purl, this.type, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SBOMComponent {\n");
        sb.append("    bomRef: ").append(this.toIndentedString(this.bomRef)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    purl: ").append(this.toIndentedString(this.purl)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

