/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.HTTPCredentialsUpdate;
import com.datadog.api.client.v2.model.HTTPIntegrationType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"base_url", "credentials", "type"})
public class HTTPIntegrationUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BASE_URL = "base_url";
    private String baseUrl;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private HTTPCredentialsUpdate credentials;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HTTPIntegrationType type;
    private Map<String, Object> additionalProperties;

    public HTTPIntegrationUpdate() {
    }

    @JsonCreator
    public HTTPIntegrationUpdate(@JsonProperty(required=true, value="type") HTTPIntegrationType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public HTTPIntegrationUpdate baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="base_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public HTTPIntegrationUpdate credentials(HTTPCredentialsUpdate credentials) {
        this.credentials = credentials;
        this.unparsed |= credentials.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HTTPCredentialsUpdate getCredentials() {
        return this.credentials;
    }

    public void setCredentials(HTTPCredentialsUpdate credentials) {
        this.credentials = credentials;
    }

    public HTTPIntegrationUpdate type(HTTPIntegrationType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HTTPIntegrationType getType() {
        return this.type;
    }

    public void setType(HTTPIntegrationType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public HTTPIntegrationUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPIntegrationUpdate httpIntegrationUpdate = (HTTPIntegrationUpdate)o;
        return Objects.equals(this.baseUrl, httpIntegrationUpdate.baseUrl) && Objects.equals(this.credentials, httpIntegrationUpdate.credentials) && Objects.equals(this.type, httpIntegrationUpdate.type) && Objects.equals(this.additionalProperties, httpIntegrationUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.baseUrl, this.credentials, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTTPIntegrationUpdate {\n");
        sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

