/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EntityV3DatadogEventItem;
import com.datadog.api.client.v2.model.EntityV3DatadogLogItem;
import com.datadog.api.client.v2.model.EntityV3DatadogPerformance;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"events", "logs", "performanceData"})
public class EntityV3QueueDatadog {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<EntityV3DatadogEventItem> events = null;
    public static final String JSON_PROPERTY_LOGS = "logs";
    private List<EntityV3DatadogLogItem> logs = null;
    public static final String JSON_PROPERTY_PERFORMANCE_DATA = "performanceData";
    private EntityV3DatadogPerformance performanceData;

    public EntityV3QueueDatadog events(List<EntityV3DatadogEventItem> events) {
        this.events = events;
        for (EntityV3DatadogEventItem item : events) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EntityV3QueueDatadog addEventsItem(EntityV3DatadogEventItem eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<EntityV3DatadogEventItem>();
        }
        this.events.add(eventsItem);
        this.unparsed |= eventsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityV3DatadogEventItem> getEvents() {
        return this.events;
    }

    public void setEvents(List<EntityV3DatadogEventItem> events) {
        this.events = events;
    }

    public EntityV3QueueDatadog logs(List<EntityV3DatadogLogItem> logs) {
        this.logs = logs;
        for (EntityV3DatadogLogItem item : logs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EntityV3QueueDatadog addLogsItem(EntityV3DatadogLogItem logsItem) {
        if (this.logs == null) {
            this.logs = new ArrayList<EntityV3DatadogLogItem>();
        }
        this.logs.add(logsItem);
        this.unparsed |= logsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="logs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityV3DatadogLogItem> getLogs() {
        return this.logs;
    }

    public void setLogs(List<EntityV3DatadogLogItem> logs) {
        this.logs = logs;
    }

    public EntityV3QueueDatadog performanceData(EntityV3DatadogPerformance performanceData) {
        this.performanceData = performanceData;
        this.unparsed |= performanceData.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="performanceData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityV3DatadogPerformance getPerformanceData() {
        return this.performanceData;
    }

    public void setPerformanceData(EntityV3DatadogPerformance performanceData) {
        this.performanceData = performanceData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityV3QueueDatadog entityV3QueueDatadog = (EntityV3QueueDatadog)o;
        return Objects.equals(this.events, entityV3QueueDatadog.events) && Objects.equals(this.logs, entityV3QueueDatadog.logs) && Objects.equals(this.performanceData, entityV3QueueDatadog.performanceData);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.logs, this.performanceData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityV3QueueDatadog {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("    performanceData: ").append(this.toIndentedString(this.performanceData)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

