/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsAPIStep;
import com.datadog.api.client.v1.model.SyntheticsAssertion;
import com.datadog.api.client.v1.model.SyntheticsConfigVariable;
import com.datadog.api.client.v1.model.SyntheticsTestRequest;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"assertions", "configVariables", "request", "steps", "variablesFromScript"})
public class SyntheticsAPITestConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = null;
    public static final String JSON_PROPERTY_CONFIG_VARIABLES = "configVariables";
    private List<SyntheticsConfigVariable> configVariables = null;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_STEPS = "steps";
    private List<SyntheticsAPIStep> steps = null;
    public static final String JSON_PROPERTY_VARIABLES_FROM_SCRIPT = "variablesFromScript";
    private String variablesFromScript;
    private Map<String, Object> additionalProperties;

    public SyntheticsAPITestConfig assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        for (SyntheticsAssertion item : assertions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsAPITestConfig addAssertionsItem(SyntheticsAssertion assertionsItem) {
        if (this.assertions == null) {
            this.assertions = new ArrayList<SyntheticsAssertion>();
        }
        this.assertions.add(assertionsItem);
        this.unparsed |= assertionsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsAPITestConfig configVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
        for (SyntheticsConfigVariable item : configVariables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsAPITestConfig addConfigVariablesItem(SyntheticsConfigVariable configVariablesItem) {
        if (this.configVariables == null) {
            this.configVariables = new ArrayList<SyntheticsConfigVariable>();
        }
        this.configVariables.add(configVariablesItem);
        this.unparsed |= configVariablesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="configVariables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsConfigVariable> getConfigVariables() {
        return this.configVariables;
    }

    public void setConfigVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
    }

    public SyntheticsAPITestConfig request(SyntheticsTestRequest request) {
        this.request = request;
        this.unparsed |= request.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsAPITestConfig steps(List<SyntheticsAPIStep> steps) {
        this.steps = steps;
        for (SyntheticsAPIStep item : steps) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsAPITestConfig addStepsItem(SyntheticsAPIStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<SyntheticsAPIStep>();
        }
        this.steps.add(stepsItem);
        this.unparsed |= stepsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="steps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsAPIStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<SyntheticsAPIStep> steps) {
        this.steps = steps;
    }

    public SyntheticsAPITestConfig variablesFromScript(String variablesFromScript) {
        this.variablesFromScript = variablesFromScript;
        return this;
    }

    @Nullable
    @JsonProperty(value="variablesFromScript")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVariablesFromScript() {
        return this.variablesFromScript;
    }

    public void setVariablesFromScript(String variablesFromScript) {
        this.variablesFromScript = variablesFromScript;
    }

    @JsonAnySetter
    public SyntheticsAPITestConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITestConfig syntheticsApiTestConfig = (SyntheticsAPITestConfig)o;
        return Objects.equals(this.assertions, syntheticsApiTestConfig.assertions) && Objects.equals(this.configVariables, syntheticsApiTestConfig.configVariables) && Objects.equals(this.request, syntheticsApiTestConfig.request) && Objects.equals(this.steps, syntheticsApiTestConfig.steps) && Objects.equals(this.variablesFromScript, syntheticsApiTestConfig.variablesFromScript) && Objects.equals(this.additionalProperties, syntheticsApiTestConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.configVariables, this.request, this.steps, this.variablesFromScript, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITestConfig {\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    configVariables: ").append(this.toIndentedString(this.configVariables)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    variablesFromScript: ").append(this.toIndentedString(this.variablesFromScript)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

