/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CodeLocation;
import com.datadog.api.client.v2.model.Library;
import com.datadog.api.client.v2.model.Remediation;
import com.datadog.api.client.v2.model.VulnerabilityCvss;
import com.datadog.api.client.v2.model.VulnerabilityDependencyLocations;
import com.datadog.api.client.v2.model.VulnerabilityEcosystem;
import com.datadog.api.client.v2.model.VulnerabilityRisks;
import com.datadog.api.client.v2.model.VulnerabilityStatus;
import com.datadog.api.client.v2.model.VulnerabilityTool;
import com.datadog.api.client.v2.model.VulnerabilityType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"advisory_id", "code_location", "cve_list", "cvss", "dependency_locations", "description", "ecosystem", "exposure_time", "first_detection", "fix_available", "language", "last_detection", "library", "remediations", "repo_digests", "risks", "status", "title", "tool", "type"})
public class VulnerabilityAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ADVISORY_ID = "advisory_id";
    private String advisoryId;
    public static final String JSON_PROPERTY_CODE_LOCATION = "code_location";
    private CodeLocation codeLocation;
    public static final String JSON_PROPERTY_CVE_LIST = "cve_list";
    private List<String> cveList = new ArrayList<String>();
    public static final String JSON_PROPERTY_CVSS = "cvss";
    private VulnerabilityCvss cvss;
    public static final String JSON_PROPERTY_DEPENDENCY_LOCATIONS = "dependency_locations";
    private VulnerabilityDependencyLocations dependencyLocations;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ECOSYSTEM = "ecosystem";
    private VulnerabilityEcosystem ecosystem;
    public static final String JSON_PROPERTY_EXPOSURE_TIME = "exposure_time";
    private Long exposureTime;
    public static final String JSON_PROPERTY_FIRST_DETECTION = "first_detection";
    private String firstDetection;
    public static final String JSON_PROPERTY_FIX_AVAILABLE = "fix_available";
    private Boolean fixAvailable;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_LAST_DETECTION = "last_detection";
    private String lastDetection;
    public static final String JSON_PROPERTY_LIBRARY = "library";
    private Library library;
    public static final String JSON_PROPERTY_REMEDIATIONS = "remediations";
    private List<Remediation> remediations = new ArrayList<Remediation>();
    public static final String JSON_PROPERTY_REPO_DIGESTS = "repo_digests";
    private List<String> repoDigests = null;
    public static final String JSON_PROPERTY_RISKS = "risks";
    private VulnerabilityRisks risks;
    public static final String JSON_PROPERTY_STATUS = "status";
    private VulnerabilityStatus status;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TOOL = "tool";
    private VulnerabilityTool tool;
    public static final String JSON_PROPERTY_TYPE = "type";
    private VulnerabilityType type;
    private Map<String, Object> additionalProperties;

    public VulnerabilityAttributes() {
    }

    @JsonCreator
    public VulnerabilityAttributes(@JsonProperty(required=true, value="cve_list") List<String> cveList, @JsonProperty(required=true, value="cvss") VulnerabilityCvss cvss, @JsonProperty(required=true, value="description") String description, @JsonProperty(required=true, value="exposure_time") Long exposureTime, @JsonProperty(required=true, value="first_detection") String firstDetection, @JsonProperty(required=true, value="fix_available") Boolean fixAvailable, @JsonProperty(required=true, value="language") String language, @JsonProperty(required=true, value="last_detection") String lastDetection, @JsonProperty(required=true, value="remediations") List<Remediation> remediations, @JsonProperty(required=true, value="risks") VulnerabilityRisks risks, @JsonProperty(required=true, value="status") VulnerabilityStatus status, @JsonProperty(required=true, value="title") String title, @JsonProperty(required=true, value="tool") VulnerabilityTool tool, @JsonProperty(required=true, value="type") VulnerabilityType type) {
        this.cveList = cveList;
        this.cvss = cvss;
        this.unparsed |= cvss.unparsed;
        this.description = description;
        this.exposureTime = exposureTime;
        this.firstDetection = firstDetection;
        this.fixAvailable = fixAvailable;
        this.language = language;
        this.lastDetection = lastDetection;
        this.remediations = remediations;
        this.risks = risks;
        this.unparsed |= risks.unparsed;
        this.status = status;
        this.unparsed |= !status.isValid();
        this.title = title;
        this.tool = tool;
        this.unparsed |= !tool.isValid();
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public VulnerabilityAttributes advisoryId(String advisoryId) {
        this.advisoryId = advisoryId;
        return this;
    }

    @Nullable
    @JsonProperty(value="advisory_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAdvisoryId() {
        return this.advisoryId;
    }

    public void setAdvisoryId(String advisoryId) {
        this.advisoryId = advisoryId;
    }

    public VulnerabilityAttributes codeLocation(CodeLocation codeLocation) {
        this.codeLocation = codeLocation;
        this.unparsed |= codeLocation.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="code_location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CodeLocation getCodeLocation() {
        return this.codeLocation;
    }

    public void setCodeLocation(CodeLocation codeLocation) {
        this.codeLocation = codeLocation;
    }

    public VulnerabilityAttributes cveList(List<String> cveList) {
        this.cveList = cveList;
        return this;
    }

    public VulnerabilityAttributes addCveListItem(String cveListItem) {
        this.cveList.add(cveListItem);
        return this;
    }

    @JsonProperty(value="cve_list")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getCveList() {
        return this.cveList;
    }

    public void setCveList(List<String> cveList) {
        this.cveList = cveList;
    }

    public VulnerabilityAttributes cvss(VulnerabilityCvss cvss) {
        this.cvss = cvss;
        this.unparsed |= cvss.unparsed;
        return this;
    }

    @JsonProperty(value="cvss")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilityCvss getCvss() {
        return this.cvss;
    }

    public void setCvss(VulnerabilityCvss cvss) {
        this.cvss = cvss;
    }

    public VulnerabilityAttributes dependencyLocations(VulnerabilityDependencyLocations dependencyLocations) {
        this.dependencyLocations = dependencyLocations;
        this.unparsed |= dependencyLocations.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="dependency_locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VulnerabilityDependencyLocations getDependencyLocations() {
        return this.dependencyLocations;
    }

    public void setDependencyLocations(VulnerabilityDependencyLocations dependencyLocations) {
        this.dependencyLocations = dependencyLocations;
    }

    public VulnerabilityAttributes description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VulnerabilityAttributes ecosystem(VulnerabilityEcosystem ecosystem) {
        this.ecosystem = ecosystem;
        this.unparsed |= !ecosystem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="ecosystem")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VulnerabilityEcosystem getEcosystem() {
        return this.ecosystem;
    }

    public void setEcosystem(VulnerabilityEcosystem ecosystem) {
        if (!ecosystem.isValid()) {
            this.unparsed = true;
        }
        this.ecosystem = ecosystem;
    }

    public VulnerabilityAttributes exposureTime(Long exposureTime) {
        this.exposureTime = exposureTime;
        return this;
    }

    @JsonProperty(value="exposure_time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getExposureTime() {
        return this.exposureTime;
    }

    public void setExposureTime(Long exposureTime) {
        this.exposureTime = exposureTime;
    }

    public VulnerabilityAttributes firstDetection(String firstDetection) {
        this.firstDetection = firstDetection;
        return this;
    }

    @JsonProperty(value="first_detection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstDetection() {
        return this.firstDetection;
    }

    public void setFirstDetection(String firstDetection) {
        this.firstDetection = firstDetection;
    }

    public VulnerabilityAttributes fixAvailable(Boolean fixAvailable) {
        this.fixAvailable = fixAvailable;
        return this;
    }

    @JsonProperty(value="fix_available")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFixAvailable() {
        return this.fixAvailable;
    }

    public void setFixAvailable(Boolean fixAvailable) {
        this.fixAvailable = fixAvailable;
    }

    public VulnerabilityAttributes language(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public VulnerabilityAttributes lastDetection(String lastDetection) {
        this.lastDetection = lastDetection;
        return this;
    }

    @JsonProperty(value="last_detection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastDetection() {
        return this.lastDetection;
    }

    public void setLastDetection(String lastDetection) {
        this.lastDetection = lastDetection;
    }

    public VulnerabilityAttributes library(Library library) {
        this.library = library;
        this.unparsed |= library.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="library")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Library getLibrary() {
        return this.library;
    }

    public void setLibrary(Library library) {
        this.library = library;
    }

    public VulnerabilityAttributes remediations(List<Remediation> remediations) {
        this.remediations = remediations;
        for (Remediation item : remediations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public VulnerabilityAttributes addRemediationsItem(Remediation remediationsItem) {
        this.remediations.add(remediationsItem);
        this.unparsed |= remediationsItem.unparsed;
        return this;
    }

    @JsonProperty(value="remediations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Remediation> getRemediations() {
        return this.remediations;
    }

    public void setRemediations(List<Remediation> remediations) {
        this.remediations = remediations;
    }

    public VulnerabilityAttributes repoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
        return this;
    }

    public VulnerabilityAttributes addRepoDigestsItem(String repoDigestsItem) {
        if (this.repoDigests == null) {
            this.repoDigests = new ArrayList<String>();
        }
        this.repoDigests.add(repoDigestsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="repo_digests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRepoDigests() {
        return this.repoDigests;
    }

    public void setRepoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
    }

    public VulnerabilityAttributes risks(VulnerabilityRisks risks) {
        this.risks = risks;
        this.unparsed |= risks.unparsed;
        return this;
    }

    @JsonProperty(value="risks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilityRisks getRisks() {
        return this.risks;
    }

    public void setRisks(VulnerabilityRisks risks) {
        this.risks = risks;
    }

    public VulnerabilityAttributes status(VulnerabilityStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(VulnerabilityStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public VulnerabilityAttributes title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public VulnerabilityAttributes tool(VulnerabilityTool tool) {
        this.tool = tool;
        this.unparsed |= !tool.isValid();
        return this;
    }

    @JsonProperty(value="tool")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilityTool getTool() {
        return this.tool;
    }

    public void setTool(VulnerabilityTool tool) {
        if (!tool.isValid()) {
            this.unparsed = true;
        }
        this.tool = tool;
    }

    public VulnerabilityAttributes type(VulnerabilityType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VulnerabilityType getType() {
        return this.type;
    }

    public void setType(VulnerabilityType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public VulnerabilityAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VulnerabilityAttributes vulnerabilityAttributes = (VulnerabilityAttributes)o;
        return Objects.equals(this.advisoryId, vulnerabilityAttributes.advisoryId) && Objects.equals(this.codeLocation, vulnerabilityAttributes.codeLocation) && Objects.equals(this.cveList, vulnerabilityAttributes.cveList) && Objects.equals(this.cvss, vulnerabilityAttributes.cvss) && Objects.equals(this.dependencyLocations, vulnerabilityAttributes.dependencyLocations) && Objects.equals(this.description, vulnerabilityAttributes.description) && Objects.equals(this.ecosystem, vulnerabilityAttributes.ecosystem) && Objects.equals(this.exposureTime, vulnerabilityAttributes.exposureTime) && Objects.equals(this.firstDetection, vulnerabilityAttributes.firstDetection) && Objects.equals(this.fixAvailable, vulnerabilityAttributes.fixAvailable) && Objects.equals(this.language, vulnerabilityAttributes.language) && Objects.equals(this.lastDetection, vulnerabilityAttributes.lastDetection) && Objects.equals(this.library, vulnerabilityAttributes.library) && Objects.equals(this.remediations, vulnerabilityAttributes.remediations) && Objects.equals(this.repoDigests, vulnerabilityAttributes.repoDigests) && Objects.equals(this.risks, vulnerabilityAttributes.risks) && Objects.equals(this.status, vulnerabilityAttributes.status) && Objects.equals(this.title, vulnerabilityAttributes.title) && Objects.equals(this.tool, vulnerabilityAttributes.tool) && Objects.equals(this.type, vulnerabilityAttributes.type) && Objects.equals(this.additionalProperties, vulnerabilityAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.advisoryId, this.codeLocation, this.cveList, this.cvss, this.dependencyLocations, this.description, this.ecosystem, this.exposureTime, this.firstDetection, this.fixAvailable, this.language, this.lastDetection, this.library, this.remediations, this.repoDigests, this.risks, this.status, this.title, this.tool, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VulnerabilityAttributes {\n");
        sb.append("    advisoryId: ").append(this.toIndentedString(this.advisoryId)).append("\n");
        sb.append("    codeLocation: ").append(this.toIndentedString(this.codeLocation)).append("\n");
        sb.append("    cveList: ").append(this.toIndentedString(this.cveList)).append("\n");
        sb.append("    cvss: ").append(this.toIndentedString(this.cvss)).append("\n");
        sb.append("    dependencyLocations: ").append(this.toIndentedString(this.dependencyLocations)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    ecosystem: ").append(this.toIndentedString(this.ecosystem)).append("\n");
        sb.append("    exposureTime: ").append(this.toIndentedString(this.exposureTime)).append("\n");
        sb.append("    firstDetection: ").append(this.toIndentedString(this.firstDetection)).append("\n");
        sb.append("    fixAvailable: ").append(this.toIndentedString(this.fixAvailable)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lastDetection: ").append(this.toIndentedString(this.lastDetection)).append("\n");
        sb.append("    library: ").append(this.toIndentedString(this.library)).append("\n");
        sb.append("    remediations: ").append(this.toIndentedString(this.remediations)).append("\n");
        sb.append("    repoDigests: ").append(this.toIndentedString(this.repoDigests)).append("\n");
        sb.append("    risks: ").append(this.toIndentedString(this.risks)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    tool: ").append(this.toIndentedString(this.tool)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

