/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AppBuilderEvent;
import com.datadog.api.client.v2.model.ComponentProperties;
import com.datadog.api.client.v2.model.ComponentType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"events", "id", "name", "properties", "type"})
public class Component {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<AppBuilderEvent> events = null;
    public static final String JSON_PROPERTY_ID = "id";
    private JsonNullable<String> id = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private ComponentProperties properties;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ComponentType type;
    private Map<String, Object> additionalProperties;

    public Component() {
    }

    @JsonCreator
    public Component(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="properties") ComponentProperties properties, @JsonProperty(required=true, value="type") ComponentType type) {
        this.name = name;
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public Component events(List<AppBuilderEvent> events) {
        this.events = events;
        for (AppBuilderEvent item : events) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Component addEventsItem(AppBuilderEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<AppBuilderEvent>();
        }
        this.events.add(eventsItem);
        this.unparsed |= eventsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AppBuilderEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<AppBuilderEvent> events) {
        this.events = events;
    }

    public Component id(String id) {
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getId() {
        return (String)this.id.orElse(null);
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getId_JsonNullable() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId_JsonNullable(JsonNullable<String> id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = JsonNullable.of((Object)id);
    }

    public Component name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component properties(ComponentProperties properties) {
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        return this;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ComponentProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ComponentProperties properties) {
        this.properties = properties;
    }

    public Component type(ComponentType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ComponentType getType() {
        return this.type;
    }

    public void setType(ComponentType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public Component putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return Objects.equals(this.events, component.events) && Objects.equals(this.id, component.id) && Objects.equals(this.name, component.name) && Objects.equals(this.properties, component.properties) && Objects.equals(this.type, component.type) && Objects.equals(this.additionalProperties, component.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.id, this.name, this.properties, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Component {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

