/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ApiKey;
import com.datadog.api.client.v1.model.ApplicationKey;
import com.datadog.api.client.v1.model.Organization;
import com.datadog.api.client.v1.model.User;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_key", "application_key", "org", "user"})
public class OrganizationCreateResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEY = "api_key";
    private ApiKey apiKey;
    public static final String JSON_PROPERTY_APPLICATION_KEY = "application_key";
    private ApplicationKey applicationKey;
    public static final String JSON_PROPERTY_ORG = "org";
    private Organization org;
    public static final String JSON_PROPERTY_USER = "user";
    private User user;
    private Map<String, Object> additionalProperties;

    public OrganizationCreateResponse apiKey(ApiKey apiKey) {
        this.apiKey = apiKey;
        this.unparsed |= apiKey.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="api_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(ApiKey apiKey) {
        this.apiKey = apiKey;
    }

    public OrganizationCreateResponse applicationKey(ApplicationKey applicationKey) {
        this.applicationKey = applicationKey;
        this.unparsed |= applicationKey.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="application_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationKey getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(ApplicationKey applicationKey) {
        this.applicationKey = applicationKey;
    }

    public OrganizationCreateResponse org(Organization org) {
        this.org = org;
        this.unparsed |= org.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="org")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrg() {
        return this.org;
    }

    public void setOrg(Organization org) {
        this.org = org;
    }

    public OrganizationCreateResponse user(User user) {
        this.user = user;
        this.unparsed |= user.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @JsonAnySetter
    public OrganizationCreateResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationCreateResponse organizationCreateResponse = (OrganizationCreateResponse)o;
        return Objects.equals(this.apiKey, organizationCreateResponse.apiKey) && Objects.equals(this.applicationKey, organizationCreateResponse.applicationKey) && Objects.equals(this.org, organizationCreateResponse.org) && Objects.equals(this.user, organizationCreateResponse.user) && Objects.equals(this.additionalProperties, organizationCreateResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.applicationKey, this.org, this.user, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationCreateResponse {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    applicationKey: ").append(this.toIndentedString(this.applicationKey)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

