/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.LogsArchive;
import com.datadog.api.client.v2.model.LogsArchiveCreateRequest;
import com.datadog.api.client.v2.model.LogsArchiveOrder;
import com.datadog.api.client.v2.model.LogsArchives;
import com.datadog.api.client.v2.model.RelationshipToRole;
import com.datadog.api.client.v2.model.RolesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class LogsArchivesApi {
    private ApiClient apiClient;

    public LogsArchivesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public LogsArchivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void addReadRoleToArchive(String archiveId, RelationshipToRole body) throws ApiException {
        this.addReadRoleToArchiveWithHttpInfo(archiveId, body);
    }

    public CompletableFuture<Void> addReadRoleToArchiveAsync(String archiveId, RelationshipToRole body) {
        return this.addReadRoleToArchiveWithHttpInfoAsync(archiveId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> addReadRoleToArchiveWithHttpInfo(String archiveId, RelationshipToRole body) throws ApiException {
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling addReadRoleToArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addReadRoleToArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.addReadRoleToArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> addReadRoleToArchiveWithHttpInfoAsync(String archiveId, RelationshipToRole body) {
        Invocation.Builder builder;
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'archiveId' when calling addReadRoleToArchive"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling addReadRoleToArchive"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.addReadRoleToArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public LogsArchive createLogsArchive(LogsArchiveCreateRequest body) throws ApiException {
        return this.createLogsArchiveWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsArchive> createLogsArchiveAsync(LogsArchiveCreateRequest body) {
        return this.createLogsArchiveWithHttpInfoAsync(body).thenApply(response -> (LogsArchive)response.getData());
    }

    public ApiResponse<LogsArchive> createLogsArchiveWithHttpInfo(LogsArchiveCreateRequest body) throws ApiException {
        LogsArchiveCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.createLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchive>(){});
    }

    public CompletableFuture<ApiResponse<LogsArchive>> createLogsArchiveWithHttpInfoAsync(LogsArchiveCreateRequest body) {
        Invocation.Builder builder;
        LogsArchiveCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createLogsArchive"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.createLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchive>(){});
    }

    public void deleteLogsArchive(String archiveId) throws ApiException {
        this.deleteLogsArchiveWithHttpInfo(archiveId);
    }

    public CompletableFuture<Void> deleteLogsArchiveAsync(String archiveId) {
        return this.deleteLogsArchiveWithHttpInfoAsync(archiveId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteLogsArchiveWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling deleteLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.deleteLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteLogsArchiveWithHttpInfoAsync(String archiveId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (archiveId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'archiveId' when calling deleteLogsArchive"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.deleteLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public LogsArchive getLogsArchive(String archiveId) throws ApiException {
        return this.getLogsArchiveWithHttpInfo(archiveId).getData();
    }

    public CompletableFuture<LogsArchive> getLogsArchiveAsync(String archiveId) {
        return this.getLogsArchiveWithHttpInfoAsync(archiveId).thenApply(response -> (LogsArchive)response.getData());
    }

    public ApiResponse<LogsArchive> getLogsArchiveWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling getLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.getLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchive>(){});
    }

    public CompletableFuture<ApiResponse<LogsArchive>> getLogsArchiveWithHttpInfoAsync(String archiveId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (archiveId == null) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'archiveId' when calling getLogsArchive"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.getLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchive>(){});
    }

    public LogsArchiveOrder getLogsArchiveOrder() throws ApiException {
        return this.getLogsArchiveOrderWithHttpInfo().getData();
    }

    public CompletableFuture<LogsArchiveOrder> getLogsArchiveOrderAsync() {
        return this.getLogsArchiveOrderWithHttpInfoAsync().thenApply(response -> (LogsArchiveOrder)response.getData());
    }

    public ApiResponse<LogsArchiveOrder> getLogsArchiveOrderWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archive-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.getLogsArchiveOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchiveOrder>(){});
    }

    public CompletableFuture<ApiResponse<LogsArchiveOrder>> getLogsArchiveOrderWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archive-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.getLogsArchiveOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsArchiveOrder>> result = new CompletableFuture<ApiResponse<LogsArchiveOrder>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchiveOrder>(){});
    }

    public RolesResponse listArchiveReadRoles(String archiveId) throws ApiException {
        return this.listArchiveReadRolesWithHttpInfo(archiveId).getData();
    }

    public CompletableFuture<RolesResponse> listArchiveReadRolesAsync(String archiveId) {
        return this.listArchiveReadRolesWithHttpInfoAsync(archiveId).thenApply(response -> (RolesResponse)response.getData());
    }

    public ApiResponse<RolesResponse> listArchiveReadRolesWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling listArchiveReadRoles");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.listArchiveReadRoles", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RolesResponse>(){});
    }

    public CompletableFuture<ApiResponse<RolesResponse>> listArchiveReadRolesWithHttpInfoAsync(String archiveId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (archiveId == null) {
            CompletableFuture<ApiResponse<RolesResponse>> result = new CompletableFuture<ApiResponse<RolesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'archiveId' when calling listArchiveReadRoles"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.listArchiveReadRoles", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RolesResponse>> result = new CompletableFuture<ApiResponse<RolesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RolesResponse>(){});
    }

    public LogsArchives listLogsArchives() throws ApiException {
        return this.listLogsArchivesWithHttpInfo().getData();
    }

    public CompletableFuture<LogsArchives> listLogsArchivesAsync() {
        return this.listLogsArchivesWithHttpInfoAsync().thenApply(response -> (LogsArchives)response.getData());
    }

    public ApiResponse<LogsArchives> listLogsArchivesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archives";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.listLogsArchives", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchives>(){});
    }

    public CompletableFuture<ApiResponse<LogsArchives>> listLogsArchivesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archives";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.listLogsArchives", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsArchives>> result = new CompletableFuture<ApiResponse<LogsArchives>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchives>(){});
    }

    public void removeRoleFromArchive(String archiveId, RelationshipToRole body) throws ApiException {
        this.removeRoleFromArchiveWithHttpInfo(archiveId, body);
    }

    public CompletableFuture<Void> removeRoleFromArchiveAsync(String archiveId, RelationshipToRole body) {
        return this.removeRoleFromArchiveWithHttpInfoAsync(archiveId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> removeRoleFromArchiveWithHttpInfo(String archiveId, RelationshipToRole body) throws ApiException {
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling removeRoleFromArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeRoleFromArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.removeRoleFromArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> removeRoleFromArchiveWithHttpInfoAsync(String archiveId, RelationshipToRole body) {
        Invocation.Builder builder;
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'archiveId' when calling removeRoleFromArchive"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling removeRoleFromArchive"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.removeRoleFromArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public LogsArchive updateLogsArchive(String archiveId, LogsArchiveCreateRequest body) throws ApiException {
        return this.updateLogsArchiveWithHttpInfo(archiveId, body).getData();
    }

    public CompletableFuture<LogsArchive> updateLogsArchiveAsync(String archiveId, LogsArchiveCreateRequest body) {
        return this.updateLogsArchiveWithHttpInfoAsync(archiveId, body).thenApply(response -> (LogsArchive)response.getData());
    }

    public ApiResponse<LogsArchive> updateLogsArchiveWithHttpInfo(String archiveId, LogsArchiveCreateRequest body) throws ApiException {
        LogsArchiveCreateRequest localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling updateLogsArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.updateLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchive>(){});
    }

    public CompletableFuture<ApiResponse<LogsArchive>> updateLogsArchiveWithHttpInfoAsync(String archiveId, LogsArchiveCreateRequest body) {
        Invocation.Builder builder;
        LogsArchiveCreateRequest localVarPostBody = body;
        if (archiveId == null) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'archiveId' when calling updateLogsArchive"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchive"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.updateLogsArchive", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsArchive>> result = new CompletableFuture<ApiResponse<LogsArchive>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchive>(){});
    }

    public LogsArchiveOrder updateLogsArchiveOrder(LogsArchiveOrder body) throws ApiException {
        return this.updateLogsArchiveOrderWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsArchiveOrder> updateLogsArchiveOrderAsync(LogsArchiveOrder body) {
        return this.updateLogsArchiveOrderWithHttpInfoAsync(body).thenApply(response -> (LogsArchiveOrder)response.getData());
    }

    public ApiResponse<LogsArchiveOrder> updateLogsArchiveOrderWithHttpInfo(LogsArchiveOrder body) throws ApiException {
        LogsArchiveOrder localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchiveOrder");
        }
        String localVarPath = "/api/v2/logs/config/archive-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsArchivesApi.updateLogsArchiveOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchiveOrder>(){});
    }

    public CompletableFuture<ApiResponse<LogsArchiveOrder>> updateLogsArchiveOrderWithHttpInfoAsync(LogsArchiveOrder body) {
        Invocation.Builder builder;
        LogsArchiveOrder localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsArchiveOrder>> result = new CompletableFuture<ApiResponse<LogsArchiveOrder>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchiveOrder"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/archive-order";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("LogsArchivesApi.updateLogsArchiveOrder", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsArchiveOrder>> result = new CompletableFuture<ApiResponse<LogsArchiveOrder>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsArchiveOrder>(){});
    }
}

