/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=LogsSortSerializer.class)
public class LogsSort {
    public static final LogsSort TIME_ASCENDING = new LogsSort("asc");
    public static final LogsSort TIME_DESCENDING = new LogsSort("desc");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("asc", "desc"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    LogsSort(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((LogsSort)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static LogsSort fromValue(String value) {
        return new LogsSort(value);
    }

    public static class LogsSortSerializer
    extends StdSerializer<LogsSort> {
        public LogsSortSerializer(Class<LogsSort> t) {
            super(t);
        }

        public LogsSortSerializer() {
            this(null);
        }

        public void serialize(LogsSort value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

