/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.JsonTimeSerializer;
import com.datadog.api.client.v1.model.DashboardLayoutType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"author_handle", "created_at", "description", "id", "is_read_only", "layout_type", "modified_at", "title", "url"})
public class DashboardSummaryDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTHOR_HANDLE = "author_handle";
    private String authorHandle;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly;
    public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
    private DashboardLayoutType layoutType;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public DashboardSummaryDefinition authorHandle(String authorHandle) {
        this.authorHandle = authorHandle;
        return this;
    }

    @Nullable
    @JsonProperty(value="author_handle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorHandle() {
        return this.authorHandle;
    }

    public void setAuthorHandle(String authorHandle) {
        this.authorHandle = authorHandle;
    }

    public DashboardSummaryDefinition createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DashboardSummaryDefinition description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public DashboardSummaryDefinition id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DashboardSummaryDefinition isReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public DashboardSummaryDefinition layoutType(DashboardLayoutType layoutType) {
        this.layoutType = layoutType;
        this.unparsed |= !layoutType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="layout_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DashboardLayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(DashboardLayoutType layoutType) {
        if (!layoutType.isValid()) {
            this.unparsed = true;
        }
        this.layoutType = layoutType;
    }

    public DashboardSummaryDefinition modifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public DashboardSummaryDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DashboardSummaryDefinition url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardSummaryDefinition dashboardSummaryDefinition = (DashboardSummaryDefinition)o;
        return Objects.equals(this.authorHandle, dashboardSummaryDefinition.authorHandle) && Objects.equals(this.createdAt, dashboardSummaryDefinition.createdAt) && Objects.equals(this.description, dashboardSummaryDefinition.description) && Objects.equals(this.id, dashboardSummaryDefinition.id) && Objects.equals(this.isReadOnly, dashboardSummaryDefinition.isReadOnly) && Objects.equals(this.layoutType, dashboardSummaryDefinition.layoutType) && Objects.equals(this.modifiedAt, dashboardSummaryDefinition.modifiedAt) && Objects.equals(this.title, dashboardSummaryDefinition.title) && Objects.equals(this.url, dashboardSummaryDefinition.url);
    }

    public int hashCode() {
        return Objects.hash(this.authorHandle, this.createdAt, this.description, this.id, this.isReadOnly, this.layoutType, this.modifiedAt, this.title, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardSummaryDefinition {\n");
        sb.append("    authorHandle: ").append(this.toIndentedString(this.authorHandle)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    layoutType: ").append(this.toIndentedString(this.layoutType)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

