/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.DistributionPointsContentEncoding;
import com.datadog.api.client.v1.model.DistributionPointsPayload;
import com.datadog.api.client.v1.model.IntakePayloadAccepted;
import com.datadog.api.client.v1.model.MetricContentEncoding;
import com.datadog.api.client.v1.model.MetricMetadata;
import com.datadog.api.client.v1.model.MetricSearchResponse;
import com.datadog.api.client.v1.model.MetricsListResponse;
import com.datadog.api.client.v1.model.MetricsPayload;
import com.datadog.api.client.v1.model.MetricsQueryResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class MetricsApi {
    private ApiClient apiClient;

    public MetricsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MetricMetadata getMetricMetadata(String metricName) throws ApiException {
        return this.getMetricMetadataWithHttpInfo(metricName).getData();
    }

    public CompletableFuture<MetricMetadata> getMetricMetadataAsync(String metricName) {
        return this.getMetricMetadataWithHttpInfoAsync(metricName).thenApply(response -> (MetricMetadata)response.getData());
    }

    public ApiResponse<MetricMetadata> getMetricMetadataWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling getMetricMetadata");
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.getMetricMetadata", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricMetadata>(){});
    }

    public CompletableFuture<ApiResponse<MetricMetadata>> getMetricMetadataWithHttpInfoAsync(String metricName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricMetadata>> result = new CompletableFuture<ApiResponse<MetricMetadata>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling getMetricMetadata"));
            return result;
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.getMetricMetadata", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricMetadata>> result = new CompletableFuture<ApiResponse<MetricMetadata>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricMetadata>(){});
    }

    public MetricsListResponse listActiveMetrics(Long from) throws ApiException {
        return this.listActiveMetricsWithHttpInfo(from, new ListActiveMetricsOptionalParameters()).getData();
    }

    public CompletableFuture<MetricsListResponse> listActiveMetricsAsync(Long from) {
        return this.listActiveMetricsWithHttpInfoAsync(from, new ListActiveMetricsOptionalParameters()).thenApply(response -> (MetricsListResponse)response.getData());
    }

    public MetricsListResponse listActiveMetrics(Long from, ListActiveMetricsOptionalParameters parameters) throws ApiException {
        return this.listActiveMetricsWithHttpInfo(from, parameters).getData();
    }

    public CompletableFuture<MetricsListResponse> listActiveMetricsAsync(Long from, ListActiveMetricsOptionalParameters parameters) {
        return this.listActiveMetricsWithHttpInfoAsync(from, parameters).thenApply(response -> (MetricsListResponse)response.getData());
    }

    public ApiResponse<MetricsListResponse> listActiveMetricsWithHttpInfo(Long from, ListActiveMetricsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling listActiveMetrics");
        }
        String host = parameters.host;
        String tagFilter = parameters.tagFilter;
        String localVarPath = "/api/v1/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "host", host));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag_filter", tagFilter));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.listActiveMetrics", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricsListResponse>> listActiveMetricsWithHttpInfoAsync(Long from, ListActiveMetricsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (from == null) {
            CompletableFuture<ApiResponse<MetricsListResponse>> result = new CompletableFuture<ApiResponse<MetricsListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'from' when calling listActiveMetrics"));
            return result;
        }
        String host = parameters.host;
        String tagFilter = parameters.tagFilter;
        String localVarPath = "/api/v1/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "host", host));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag_filter", tagFilter));
        try {
            builder = this.apiClient.createBuilder("MetricsApi.listActiveMetrics", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricsListResponse>> result = new CompletableFuture<ApiResponse<MetricsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricsListResponse>(){});
    }

    public MetricSearchResponse listMetrics(String q) throws ApiException {
        return this.listMetricsWithHttpInfo(q).getData();
    }

    public CompletableFuture<MetricSearchResponse> listMetricsAsync(String q) {
        return this.listMetricsWithHttpInfoAsync(q).thenApply(response -> (MetricSearchResponse)response.getData());
    }

    public ApiResponse<MetricSearchResponse> listMetricsWithHttpInfo(String q) throws ApiException {
        Object localVarPostBody = null;
        if (q == null) {
            throw new ApiException(400, "Missing the required parameter 'q' when calling listMetrics");
        }
        String localVarPath = "/api/v1/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "q", q));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.listMetrics", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricSearchResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricSearchResponse>> listMetricsWithHttpInfoAsync(String q) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (q == null) {
            CompletableFuture<ApiResponse<MetricSearchResponse>> result = new CompletableFuture<ApiResponse<MetricSearchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'q' when calling listMetrics"));
            return result;
        }
        String localVarPath = "/api/v1/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "q", q));
        try {
            builder = this.apiClient.createBuilder("MetricsApi.listMetrics", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricSearchResponse>> result = new CompletableFuture<ApiResponse<MetricSearchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricSearchResponse>(){});
    }

    public MetricsQueryResponse queryMetrics(Long from, Long to, String query) throws ApiException {
        return this.queryMetricsWithHttpInfo(from, to, query).getData();
    }

    public CompletableFuture<MetricsQueryResponse> queryMetricsAsync(Long from, Long to, String query) {
        return this.queryMetricsWithHttpInfoAsync(from, to, query).thenApply(response -> (MetricsQueryResponse)response.getData());
    }

    public ApiResponse<MetricsQueryResponse> queryMetricsWithHttpInfo(Long from, Long to, String query) throws ApiException {
        Object localVarPostBody = null;
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling queryMetrics");
        }
        if (to == null) {
            throw new ApiException(400, "Missing the required parameter 'to' when calling queryMetrics");
        }
        if (query == null) {
            throw new ApiException(400, "Missing the required parameter 'query' when calling queryMetrics");
        }
        String localVarPath = "/api/v1/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.queryMetrics", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricsQueryResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricsQueryResponse>> queryMetricsWithHttpInfoAsync(Long from, Long to, String query) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (from == null) {
            CompletableFuture<ApiResponse<MetricsQueryResponse>> result = new CompletableFuture<ApiResponse<MetricsQueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'from' when calling queryMetrics"));
            return result;
        }
        if (to == null) {
            CompletableFuture<ApiResponse<MetricsQueryResponse>> result = new CompletableFuture<ApiResponse<MetricsQueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'to' when calling queryMetrics"));
            return result;
        }
        if (query == null) {
            CompletableFuture<ApiResponse<MetricsQueryResponse>> result = new CompletableFuture<ApiResponse<MetricsQueryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'query' when calling queryMetrics"));
            return result;
        }
        String localVarPath = "/api/v1/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        try {
            builder = this.apiClient.createBuilder("MetricsApi.queryMetrics", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricsQueryResponse>> result = new CompletableFuture<ApiResponse<MetricsQueryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricsQueryResponse>(){});
    }

    public IntakePayloadAccepted submitDistributionPoints(DistributionPointsPayload body) throws ApiException {
        return this.submitDistributionPointsWithHttpInfo(body, new SubmitDistributionPointsOptionalParameters()).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitDistributionPointsAsync(DistributionPointsPayload body) {
        return this.submitDistributionPointsWithHttpInfoAsync(body, new SubmitDistributionPointsOptionalParameters()).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public IntakePayloadAccepted submitDistributionPoints(DistributionPointsPayload body, SubmitDistributionPointsOptionalParameters parameters) throws ApiException {
        return this.submitDistributionPointsWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitDistributionPointsAsync(DistributionPointsPayload body, SubmitDistributionPointsOptionalParameters parameters) {
        return this.submitDistributionPointsWithHttpInfoAsync(body, parameters).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public ApiResponse<IntakePayloadAccepted> submitDistributionPointsWithHttpInfo(DistributionPointsPayload body, SubmitDistributionPointsOptionalParameters parameters) throws ApiException {
        DistributionPointsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitDistributionPoints");
        }
        DistributionPointsContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v1/distribution_points";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.submitDistributionPoints", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/json", "application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"text/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public CompletableFuture<ApiResponse<IntakePayloadAccepted>> submitDistributionPointsWithHttpInfoAsync(DistributionPointsPayload body, SubmitDistributionPointsOptionalParameters parameters) {
        Invocation.Builder builder;
        DistributionPointsPayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling submitDistributionPoints"));
            return result;
        }
        DistributionPointsContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v1/distribution_points";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        try {
            builder = this.apiClient.createBuilder("MetricsApi.submitDistributionPoints", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/json", "application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"text/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public IntakePayloadAccepted submitMetrics(MetricsPayload body) throws ApiException {
        return this.submitMetricsWithHttpInfo(body, new SubmitMetricsOptionalParameters()).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitMetricsAsync(MetricsPayload body) {
        return this.submitMetricsWithHttpInfoAsync(body, new SubmitMetricsOptionalParameters()).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public IntakePayloadAccepted submitMetrics(MetricsPayload body, SubmitMetricsOptionalParameters parameters) throws ApiException {
        return this.submitMetricsWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitMetricsAsync(MetricsPayload body, SubmitMetricsOptionalParameters parameters) {
        return this.submitMetricsWithHttpInfoAsync(body, parameters).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public ApiResponse<IntakePayloadAccepted> submitMetricsWithHttpInfo(MetricsPayload body, SubmitMetricsOptionalParameters parameters) throws ApiException {
        MetricsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitMetrics");
        }
        MetricContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v1/series";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.submitMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/json", "application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"text/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public CompletableFuture<ApiResponse<IntakePayloadAccepted>> submitMetricsWithHttpInfoAsync(MetricsPayload body, SubmitMetricsOptionalParameters parameters) {
        Invocation.Builder builder;
        MetricsPayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling submitMetrics"));
            return result;
        }
        MetricContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v1/series";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        try {
            builder = this.apiClient.createBuilder("MetricsApi.submitMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/json", "application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"text/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public MetricMetadata updateMetricMetadata(String metricName, MetricMetadata body) throws ApiException {
        return this.updateMetricMetadataWithHttpInfo(metricName, body).getData();
    }

    public CompletableFuture<MetricMetadata> updateMetricMetadataAsync(String metricName, MetricMetadata body) {
        return this.updateMetricMetadataWithHttpInfoAsync(metricName, body).thenApply(response -> (MetricMetadata)response.getData());
    }

    public ApiResponse<MetricMetadata> updateMetricMetadataWithHttpInfo(String metricName, MetricMetadata body) throws ApiException {
        MetricMetadata localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling updateMetricMetadata");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMetricMetadata");
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MetricsApi.updateMetricMetadata", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricMetadata>(){});
    }

    public CompletableFuture<ApiResponse<MetricMetadata>> updateMetricMetadataWithHttpInfoAsync(String metricName, MetricMetadata body) {
        Invocation.Builder builder;
        MetricMetadata localVarPostBody = body;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricMetadata>> result = new CompletableFuture<ApiResponse<MetricMetadata>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling updateMetricMetadata"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MetricMetadata>> result = new CompletableFuture<ApiResponse<MetricMetadata>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateMetricMetadata"));
            return result;
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.updateMetricMetadata", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricMetadata>> result = new CompletableFuture<ApiResponse<MetricMetadata>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricMetadata>(){});
    }

    public static class SubmitMetricsOptionalParameters {
        private MetricContentEncoding contentEncoding;

        public SubmitMetricsOptionalParameters contentEncoding(MetricContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }
    }

    public static class SubmitDistributionPointsOptionalParameters {
        private DistributionPointsContentEncoding contentEncoding;

        public SubmitDistributionPointsOptionalParameters contentEncoding(DistributionPointsContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }
    }

    public static class ListActiveMetricsOptionalParameters {
        private String host;
        private String tagFilter;

        public ListActiveMetricsOptionalParameters host(String host) {
            this.host = host;
            return this;
        }

        public ListActiveMetricsOptionalParameters tagFilter(String tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }
    }
}

