/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DowntimeScheduleCurrentDowntimeResponse;
import com.datadog.api.client.v2.model.DowntimeScheduleRecurrenceResponse;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"current_downtime", "recurrences", "timezone"})
public class DowntimeScheduleRecurrencesResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CURRENT_DOWNTIME = "current_downtime";
    private DowntimeScheduleCurrentDowntimeResponse currentDowntime;
    public static final String JSON_PROPERTY_RECURRENCES = "recurrences";
    private List<DowntimeScheduleRecurrenceResponse> recurrences = new ArrayList<DowntimeScheduleRecurrenceResponse>();
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone = "UTC";
    private Map<String, Object> additionalProperties;

    public DowntimeScheduleRecurrencesResponse() {
    }

    @JsonCreator
    public DowntimeScheduleRecurrencesResponse(@JsonProperty(required=true, value="recurrences") List<DowntimeScheduleRecurrenceResponse> recurrences) {
        this.recurrences = recurrences;
    }

    public DowntimeScheduleRecurrencesResponse currentDowntime(DowntimeScheduleCurrentDowntimeResponse currentDowntime) {
        this.currentDowntime = currentDowntime;
        this.unparsed |= currentDowntime.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="current_downtime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowntimeScheduleCurrentDowntimeResponse getCurrentDowntime() {
        return this.currentDowntime;
    }

    public void setCurrentDowntime(DowntimeScheduleCurrentDowntimeResponse currentDowntime) {
        this.currentDowntime = currentDowntime;
    }

    public DowntimeScheduleRecurrencesResponse recurrences(List<DowntimeScheduleRecurrenceResponse> recurrences) {
        this.recurrences = recurrences;
        for (DowntimeScheduleRecurrenceResponse item : recurrences) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public DowntimeScheduleRecurrencesResponse addRecurrencesItem(DowntimeScheduleRecurrenceResponse recurrencesItem) {
        this.recurrences.add(recurrencesItem);
        this.unparsed |= recurrencesItem.unparsed;
        return this;
    }

    @JsonProperty(value="recurrences")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<DowntimeScheduleRecurrenceResponse> getRecurrences() {
        return this.recurrences;
    }

    public void setRecurrences(List<DowntimeScheduleRecurrenceResponse> recurrences) {
        this.recurrences = recurrences;
    }

    public DowntimeScheduleRecurrencesResponse timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @JsonAnySetter
    public DowntimeScheduleRecurrencesResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DowntimeScheduleRecurrencesResponse downtimeScheduleRecurrencesResponse = (DowntimeScheduleRecurrencesResponse)o;
        return Objects.equals(this.currentDowntime, downtimeScheduleRecurrencesResponse.currentDowntime) && Objects.equals(this.recurrences, downtimeScheduleRecurrencesResponse.recurrences) && Objects.equals(this.timezone, downtimeScheduleRecurrencesResponse.timezone) && Objects.equals(this.additionalProperties, downtimeScheduleRecurrencesResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.currentDowntime, this.recurrences, this.timezone, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DowntimeScheduleRecurrencesResponse {\n");
        sb.append("    currentDowntime: ").append(this.toIndentedString(this.currentDowntime)).append("\n");
        sb.append("    recurrences: ").append(this.toIndentedString(this.recurrences)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

