/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentCreateAttributes;
import com.datadog.api.client.v2.model.IncidentCreateRelationships;
import com.datadog.api.client.v2.model.IncidentType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class IncidentCreateData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentCreateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentCreateRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentType type = IncidentType.INCIDENTS;
    private Map<String, Object> additionalProperties;

    public IncidentCreateData() {
    }

    @JsonCreator
    public IncidentCreateData(@JsonProperty(required=true, value="attributes") IncidentCreateAttributes attributes, @JsonProperty(required=true, value="type") IncidentType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public IncidentCreateData attributes(IncidentCreateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentCreateData relationships(IncidentCreateRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentCreateRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentCreateRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentCreateData type(IncidentType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentType getType() {
        return this.type;
    }

    public void setType(IncidentType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public IncidentCreateData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentCreateData incidentCreateData = (IncidentCreateData)o;
        return Objects.equals(this.attributes, incidentCreateData.attributes) && Objects.equals(this.relationships, incidentCreateData.relationships) && Objects.equals(this.type, incidentCreateData.type) && Objects.equals(this.additionalProperties, incidentCreateData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentCreateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

