/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ContainerMetaPageType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"cursor", "limit", "next_cursor", "prev_cursor", "total", "type"})
public class ContainerMetaPage {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CURSOR = "cursor";
    private String cursor;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit;
    public static final String JSON_PROPERTY_NEXT_CURSOR = "next_cursor";
    private String nextCursor;
    public static final String JSON_PROPERTY_PREV_CURSOR = "prev_cursor";
    private JsonNullable<String> prevCursor = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Long total;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ContainerMetaPageType type = ContainerMetaPageType.CURSOR_LIMIT;
    private Map<String, Object> additionalProperties;

    public ContainerMetaPage cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @JsonProperty(value="cursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public ContainerMetaPage limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ContainerMetaPage nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @JsonProperty(value="next_cursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public ContainerMetaPage prevCursor(String prevCursor) {
        this.prevCursor = JsonNullable.of((Object)prevCursor);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getPrevCursor() {
        return (String)this.prevCursor.orElse(null);
    }

    @JsonProperty(value="prev_cursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPrevCursor_JsonNullable() {
        return this.prevCursor;
    }

    @JsonProperty(value="prev_cursor")
    public void setPrevCursor_JsonNullable(JsonNullable<String> prevCursor) {
        this.prevCursor = prevCursor;
    }

    public void setPrevCursor(String prevCursor) {
        this.prevCursor = JsonNullable.of((Object)prevCursor);
    }

    public ContainerMetaPage total(Long total) {
        this.total = total;
        return this;
    }

    @Nullable
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public ContainerMetaPage type(ContainerMetaPageType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContainerMetaPageType getType() {
        return this.type;
    }

    public void setType(ContainerMetaPageType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public ContainerMetaPage putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerMetaPage containerMetaPage = (ContainerMetaPage)o;
        return Objects.equals(this.cursor, containerMetaPage.cursor) && Objects.equals(this.limit, containerMetaPage.limit) && Objects.equals(this.nextCursor, containerMetaPage.nextCursor) && Objects.equals(this.prevCursor, containerMetaPage.prevCursor) && Objects.equals(this.total, containerMetaPage.total) && Objects.equals(this.type, containerMetaPage.type) && Objects.equals(this.additionalProperties, containerMetaPage.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.nextCursor, this.prevCursor, this.total, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerMetaPage {\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    prevCursor: ").append(this.toIndentedString(this.prevCursor)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

