/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.OrgConfigGetResponse;
import com.datadog.api.client.v2.model.OrgConfigListResponse;
import com.datadog.api.client.v2.model.OrgConfigWriteRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OrganizationsApi {
    private ApiClient apiClient;

    public OrganizationsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OrganizationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrgConfigGetResponse getOrgConfig(String orgConfigName) throws ApiException {
        return this.getOrgConfigWithHttpInfo(orgConfigName).getData();
    }

    public CompletableFuture<OrgConfigGetResponse> getOrgConfigAsync(String orgConfigName) {
        return this.getOrgConfigWithHttpInfoAsync(orgConfigName).thenApply(response -> (OrgConfigGetResponse)response.getData());
    }

    public ApiResponse<OrgConfigGetResponse> getOrgConfigWithHttpInfo(String orgConfigName) throws ApiException {
        Object localVarPostBody = null;
        if (orgConfigName == null) {
            throw new ApiException(400, "Missing the required parameter 'orgConfigName' when calling getOrgConfig");
        }
        String localVarPath = "/api/v2/org_configs/{org_config_name}".replaceAll("\\{org_config_name\\}", this.apiClient.escapeString(orgConfigName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrganizationsApi.getOrgConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConfigGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrgConfigGetResponse>> getOrgConfigWithHttpInfoAsync(String orgConfigName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (orgConfigName == null) {
            CompletableFuture<ApiResponse<OrgConfigGetResponse>> result = new CompletableFuture<ApiResponse<OrgConfigGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'orgConfigName' when calling getOrgConfig"));
            return result;
        }
        String localVarPath = "/api/v2/org_configs/{org_config_name}".replaceAll("\\{org_config_name\\}", this.apiClient.escapeString(orgConfigName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OrganizationsApi.getOrgConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrgConfigGetResponse>> result = new CompletableFuture<ApiResponse<OrgConfigGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConfigGetResponse>(){});
    }

    public OrgConfigListResponse listOrgConfigs() throws ApiException {
        return this.listOrgConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<OrgConfigListResponse> listOrgConfigsAsync() {
        return this.listOrgConfigsWithHttpInfoAsync().thenApply(response -> (OrgConfigListResponse)response.getData());
    }

    public ApiResponse<OrgConfigListResponse> listOrgConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/org_configs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrganizationsApi.listOrgConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConfigListResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrgConfigListResponse>> listOrgConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/org_configs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OrganizationsApi.listOrgConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrgConfigListResponse>> result = new CompletableFuture<ApiResponse<OrgConfigListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConfigListResponse>(){});
    }

    public OrgConfigGetResponse updateOrgConfig(String orgConfigName, OrgConfigWriteRequest body) throws ApiException {
        return this.updateOrgConfigWithHttpInfo(orgConfigName, body).getData();
    }

    public CompletableFuture<OrgConfigGetResponse> updateOrgConfigAsync(String orgConfigName, OrgConfigWriteRequest body) {
        return this.updateOrgConfigWithHttpInfoAsync(orgConfigName, body).thenApply(response -> (OrgConfigGetResponse)response.getData());
    }

    public ApiResponse<OrgConfigGetResponse> updateOrgConfigWithHttpInfo(String orgConfigName, OrgConfigWriteRequest body) throws ApiException {
        OrgConfigWriteRequest localVarPostBody = body;
        if (orgConfigName == null) {
            throw new ApiException(400, "Missing the required parameter 'orgConfigName' when calling updateOrgConfig");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrgConfig");
        }
        String localVarPath = "/api/v2/org_configs/{org_config_name}".replaceAll("\\{org_config_name\\}", this.apiClient.escapeString(orgConfigName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrganizationsApi.updateOrgConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConfigGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrgConfigGetResponse>> updateOrgConfigWithHttpInfoAsync(String orgConfigName, OrgConfigWriteRequest body) {
        Invocation.Builder builder;
        OrgConfigWriteRequest localVarPostBody = body;
        if (orgConfigName == null) {
            CompletableFuture<ApiResponse<OrgConfigGetResponse>> result = new CompletableFuture<ApiResponse<OrgConfigGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'orgConfigName' when calling updateOrgConfig"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OrgConfigGetResponse>> result = new CompletableFuture<ApiResponse<OrgConfigGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOrgConfig"));
            return result;
        }
        String localVarPath = "/api/v2/org_configs/{org_config_name}".replaceAll("\\{org_config_name\\}", this.apiClient.escapeString(orgConfigName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OrganizationsApi.updateOrgConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrgConfigGetResponse>> result = new CompletableFuture<ApiResponse<OrgConfigGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrgConfigGetResponse>(){});
    }

    public void uploadIdPMetadata() throws ApiException {
        this.uploadIdPMetadataWithHttpInfo(new UploadIdPMetadataOptionalParameters());
    }

    public CompletableFuture<Void> uploadIdPMetadataAsync() {
        return this.uploadIdPMetadataWithHttpInfoAsync(new UploadIdPMetadataOptionalParameters()).thenApply(response -> (Void)response.getData());
    }

    public void uploadIdPMetadata(UploadIdPMetadataOptionalParameters parameters) throws ApiException {
        this.uploadIdPMetadataWithHttpInfo(parameters);
    }

    public CompletableFuture<Void> uploadIdPMetadataAsync(UploadIdPMetadataOptionalParameters parameters) {
        return this.uploadIdPMetadataWithHttpInfoAsync(parameters).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> uploadIdPMetadataWithHttpInfo(UploadIdPMetadataOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        File idpFile = parameters.idpFile;
        String localVarPath = "/api/v2/saml_configurations/idp_metadata";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idpFile != null) {
            localVarFormParams.put("idp_file", idpFile);
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OrganizationsApi.uploadIdPMetadata", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, null);
    }

    public CompletableFuture<ApiResponse<Void>> uploadIdPMetadataWithHttpInfoAsync(UploadIdPMetadataOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        File idpFile = parameters.idpFile;
        String localVarPath = "/api/v2/saml_configurations/idp_metadata";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idpFile != null) {
            localVarFormParams.put("idp_file", idpFile);
        }
        try {
            builder = this.apiClient.createBuilder("v2.OrganizationsApi.uploadIdPMetadata", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, null);
    }

    public static class UploadIdPMetadataOptionalParameters {
        private File idpFile;

        public UploadIdPMetadataOptionalParameters idpFile(File idpFile) {
            this.idpFile = idpFile;
            return this;
        }
    }
}

