/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.GetDeviceResponse;
import com.datadog.api.client.v2.model.GetInterfacesResponse;
import com.datadog.api.client.v2.model.ListDevicesResponse;
import com.datadog.api.client.v2.model.ListTagsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class NetworkDeviceMonitoringApi {
    private ApiClient apiClient;

    public NetworkDeviceMonitoringApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public NetworkDeviceMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GetDeviceResponse getDevice(String deviceId) throws ApiException {
        return this.getDeviceWithHttpInfo(deviceId).getData();
    }

    public CompletableFuture<GetDeviceResponse> getDeviceAsync(String deviceId) {
        return this.getDeviceWithHttpInfoAsync(deviceId).thenApply(response -> (GetDeviceResponse)response.getData());
    }

    public ApiResponse<GetDeviceResponse> getDeviceWithHttpInfo(String deviceId) throws ApiException {
        Object localVarPostBody = null;
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling getDevice");
        }
        String localVarPath = "/api/v2/ndm/devices/{device_id}".replaceAll("\\{device_id\\}", this.apiClient.escapeString(deviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.getDevice", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetDeviceResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetDeviceResponse>> getDeviceWithHttpInfoAsync(String deviceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (deviceId == null) {
            CompletableFuture<ApiResponse<GetDeviceResponse>> result = new CompletableFuture<ApiResponse<GetDeviceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deviceId' when calling getDevice"));
            return result;
        }
        String localVarPath = "/api/v2/ndm/devices/{device_id}".replaceAll("\\{device_id\\}", this.apiClient.escapeString(deviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.getDevice", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetDeviceResponse>> result = new CompletableFuture<ApiResponse<GetDeviceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetDeviceResponse>(){});
    }

    public GetInterfacesResponse getInterfaces(String deviceId) throws ApiException {
        return this.getInterfacesWithHttpInfo(deviceId).getData();
    }

    public CompletableFuture<GetInterfacesResponse> getInterfacesAsync(String deviceId) {
        return this.getInterfacesWithHttpInfoAsync(deviceId).thenApply(response -> (GetInterfacesResponse)response.getData());
    }

    public ApiResponse<GetInterfacesResponse> getInterfacesWithHttpInfo(String deviceId) throws ApiException {
        Object localVarPostBody = null;
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling getInterfaces");
        }
        String localVarPath = "/api/v2/ndm/interfaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "device_id", deviceId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.getInterfaces", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetInterfacesResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetInterfacesResponse>> getInterfacesWithHttpInfoAsync(String deviceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (deviceId == null) {
            CompletableFuture<ApiResponse<GetInterfacesResponse>> result = new CompletableFuture<ApiResponse<GetInterfacesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deviceId' when calling getInterfaces"));
            return result;
        }
        String localVarPath = "/api/v2/ndm/interfaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "device_id", deviceId));
        try {
            builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.getInterfaces", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetInterfacesResponse>> result = new CompletableFuture<ApiResponse<GetInterfacesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetInterfacesResponse>(){});
    }

    public ListDevicesResponse listDevices() throws ApiException {
        return this.listDevicesWithHttpInfo(new ListDevicesOptionalParameters()).getData();
    }

    public CompletableFuture<ListDevicesResponse> listDevicesAsync() {
        return this.listDevicesWithHttpInfoAsync(new ListDevicesOptionalParameters()).thenApply(response -> (ListDevicesResponse)response.getData());
    }

    public ListDevicesResponse listDevices(ListDevicesOptionalParameters parameters) throws ApiException {
        return this.listDevicesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListDevicesResponse> listDevicesAsync(ListDevicesOptionalParameters parameters) {
        return this.listDevicesWithHttpInfoAsync(parameters).thenApply(response -> (ListDevicesResponse)response.getData());
    }

    public ApiResponse<ListDevicesResponse> listDevicesWithHttpInfo(ListDevicesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        String sort = parameters.sort;
        String filterTag = parameters.filterTag;
        String localVarPath = "/api/v2/ndm/devices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tag]", filterTag));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.listDevices", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListDevicesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListDevicesResponse>> listDevicesWithHttpInfoAsync(ListDevicesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        String sort = parameters.sort;
        String filterTag = parameters.filterTag;
        String localVarPath = "/api/v2/ndm/devices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tag]", filterTag));
        try {
            builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.listDevices", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListDevicesResponse>> result = new CompletableFuture<ApiResponse<ListDevicesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListDevicesResponse>(){});
    }

    public ListTagsResponse listDeviceUserTags(String deviceId) throws ApiException {
        return this.listDeviceUserTagsWithHttpInfo(deviceId).getData();
    }

    public CompletableFuture<ListTagsResponse> listDeviceUserTagsAsync(String deviceId) {
        return this.listDeviceUserTagsWithHttpInfoAsync(deviceId).thenApply(response -> (ListTagsResponse)response.getData());
    }

    public ApiResponse<ListTagsResponse> listDeviceUserTagsWithHttpInfo(String deviceId) throws ApiException {
        Object localVarPostBody = null;
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling listDeviceUserTags");
        }
        String localVarPath = "/api/v2/ndm/tags/devices/{device_id}".replaceAll("\\{device_id\\}", this.apiClient.escapeString(deviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.listDeviceUserTags", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListTagsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListTagsResponse>> listDeviceUserTagsWithHttpInfoAsync(String deviceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (deviceId == null) {
            CompletableFuture<ApiResponse<ListTagsResponse>> result = new CompletableFuture<ApiResponse<ListTagsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deviceId' when calling listDeviceUserTags"));
            return result;
        }
        String localVarPath = "/api/v2/ndm/tags/devices/{device_id}".replaceAll("\\{device_id\\}", this.apiClient.escapeString(deviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.listDeviceUserTags", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListTagsResponse>> result = new CompletableFuture<ApiResponse<ListTagsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListTagsResponse>(){});
    }

    public ListTagsResponse updateDeviceUserTags(String deviceId, ListTagsResponse body) throws ApiException {
        return this.updateDeviceUserTagsWithHttpInfo(deviceId, body).getData();
    }

    public CompletableFuture<ListTagsResponse> updateDeviceUserTagsAsync(String deviceId, ListTagsResponse body) {
        return this.updateDeviceUserTagsWithHttpInfoAsync(deviceId, body).thenApply(response -> (ListTagsResponse)response.getData());
    }

    public ApiResponse<ListTagsResponse> updateDeviceUserTagsWithHttpInfo(String deviceId, ListTagsResponse body) throws ApiException {
        ListTagsResponse localVarPostBody = body;
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling updateDeviceUserTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDeviceUserTags");
        }
        String localVarPath = "/api/v2/ndm/tags/devices/{device_id}".replaceAll("\\{device_id\\}", this.apiClient.escapeString(deviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.updateDeviceUserTags", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListTagsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListTagsResponse>> updateDeviceUserTagsWithHttpInfoAsync(String deviceId, ListTagsResponse body) {
        Invocation.Builder builder;
        ListTagsResponse localVarPostBody = body;
        if (deviceId == null) {
            CompletableFuture<ApiResponse<ListTagsResponse>> result = new CompletableFuture<ApiResponse<ListTagsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deviceId' when calling updateDeviceUserTags"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ListTagsResponse>> result = new CompletableFuture<ApiResponse<ListTagsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDeviceUserTags"));
            return result;
        }
        String localVarPath = "/api/v2/ndm/tags/devices/{device_id}".replaceAll("\\{device_id\\}", this.apiClient.escapeString(deviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.NetworkDeviceMonitoringApi.updateDeviceUserTags", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListTagsResponse>> result = new CompletableFuture<ApiResponse<ListTagsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListTagsResponse>(){});
    }

    public static class ListDevicesOptionalParameters {
        private Long pageNumber;
        private Long pageSize;
        private String sort;
        private String filterTag;

        public ListDevicesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListDevicesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListDevicesOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListDevicesOptionalParameters filterTag(String filterTag) {
            this.filterTag = filterTag;
            return this;
        }
    }
}

