/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.IncidentRelatedObject;
import com.datadog.api.client.v2.model.IncidentTeamCreateRequest;
import com.datadog.api.client.v2.model.IncidentTeamResponse;
import com.datadog.api.client.v2.model.IncidentTeamUpdateRequest;
import com.datadog.api.client.v2.model.IncidentTeamsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class IncidentTeamsApi {
    private ApiClient apiClient;

    public IncidentTeamsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public IncidentTeamsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Deprecated
    public IncidentTeamResponse createIncidentTeam(IncidentTeamCreateRequest body) throws ApiException {
        return this.createIncidentTeamWithHttpInfo(body).getData();
    }

    @Deprecated
    public CompletableFuture<IncidentTeamResponse> createIncidentTeamAsync(IncidentTeamCreateRequest body) {
        return this.createIncidentTeamWithHttpInfoAsync(body).thenApply(response -> (IncidentTeamResponse)response.getData());
    }

    @Deprecated
    public ApiResponse<IncidentTeamResponse> createIncidentTeamWithHttpInfo(IncidentTeamCreateRequest body) throws ApiException {
        String operationId = "createIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTeamCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentTeam");
        }
        String localVarPath = "/api/v2/teams";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.createIncidentTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamResponse>(){});
    }

    @Deprecated
    public CompletableFuture<ApiResponse<IncidentTeamResponse>> createIncidentTeamWithHttpInfoAsync(IncidentTeamCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTeamCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncidentTeam"));
            return result;
        }
        String localVarPath = "/api/v2/teams";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.createIncidentTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamResponse>(){});
    }

    @Deprecated
    public void deleteIncidentTeam(String teamId) throws ApiException {
        this.deleteIncidentTeamWithHttpInfo(teamId);
    }

    @Deprecated
    public CompletableFuture<Void> deleteIncidentTeamAsync(String teamId) {
        return this.deleteIncidentTeamWithHttpInfoAsync(teamId).thenApply(response -> (Void)response.getData());
    }

    @Deprecated
    public ApiResponse<Void> deleteIncidentTeamWithHttpInfo(String teamId) throws ApiException {
        String operationId = "deleteIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.deleteIncidentTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    @Deprecated
    public CompletableFuture<ApiResponse<Void>> deleteIncidentTeamWithHttpInfoAsync(String teamId) {
        Invocation.Builder builder;
        String operationId = "deleteIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling deleteIncidentTeam"));
            return result;
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.deleteIncidentTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    @Deprecated
    public IncidentTeamResponse getIncidentTeam(String teamId) throws ApiException {
        return this.getIncidentTeamWithHttpInfo(teamId, new GetIncidentTeamOptionalParameters()).getData();
    }

    @Deprecated
    public CompletableFuture<IncidentTeamResponse> getIncidentTeamAsync(String teamId) {
        return this.getIncidentTeamWithHttpInfoAsync(teamId, new GetIncidentTeamOptionalParameters()).thenApply(response -> (IncidentTeamResponse)response.getData());
    }

    @Deprecated
    public IncidentTeamResponse getIncidentTeam(String teamId, GetIncidentTeamOptionalParameters parameters) throws ApiException {
        return this.getIncidentTeamWithHttpInfo(teamId, parameters).getData();
    }

    @Deprecated
    public CompletableFuture<IncidentTeamResponse> getIncidentTeamAsync(String teamId, GetIncidentTeamOptionalParameters parameters) {
        return this.getIncidentTeamWithHttpInfoAsync(teamId, parameters).thenApply(response -> (IncidentTeamResponse)response.getData());
    }

    @Deprecated
    public ApiResponse<IncidentTeamResponse> getIncidentTeamWithHttpInfo(String teamId, GetIncidentTeamOptionalParameters parameters) throws ApiException {
        String operationId = "getIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getIncidentTeam");
        }
        IncidentRelatedObject include = parameters.include;
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.getIncidentTeam", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamResponse>(){});
    }

    @Deprecated
    public CompletableFuture<ApiResponse<IncidentTeamResponse>> getIncidentTeamWithHttpInfoAsync(String teamId, GetIncidentTeamOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getIncidentTeam"));
            return result;
        }
        IncidentRelatedObject include = parameters.include;
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.getIncidentTeam", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamResponse>(){});
    }

    @Deprecated
    public IncidentTeamsResponse listIncidentTeams() throws ApiException {
        return this.listIncidentTeamsWithHttpInfo(new ListIncidentTeamsOptionalParameters()).getData();
    }

    @Deprecated
    public CompletableFuture<IncidentTeamsResponse> listIncidentTeamsAsync() {
        return this.listIncidentTeamsWithHttpInfoAsync(new ListIncidentTeamsOptionalParameters()).thenApply(response -> (IncidentTeamsResponse)response.getData());
    }

    @Deprecated
    public IncidentTeamsResponse listIncidentTeams(ListIncidentTeamsOptionalParameters parameters) throws ApiException {
        return this.listIncidentTeamsWithHttpInfo(parameters).getData();
    }

    @Deprecated
    public CompletableFuture<IncidentTeamsResponse> listIncidentTeamsAsync(ListIncidentTeamsOptionalParameters parameters) {
        return this.listIncidentTeamsWithHttpInfoAsync(parameters).thenApply(response -> (IncidentTeamsResponse)response.getData());
    }

    @Deprecated
    public ApiResponse<IncidentTeamsResponse> listIncidentTeamsWithHttpInfo(ListIncidentTeamsOptionalParameters parameters) throws ApiException {
        String operationId = "listIncidentTeams";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        IncidentRelatedObject include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.listIncidentTeams", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamsResponse>(){});
    }

    @Deprecated
    public CompletableFuture<ApiResponse<IncidentTeamsResponse>> listIncidentTeamsWithHttpInfoAsync(ListIncidentTeamsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listIncidentTeams";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTeamsResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        IncidentRelatedObject include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        try {
            builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.listIncidentTeams", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTeamsResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamsResponse>(){});
    }

    @Deprecated
    public IncidentTeamResponse updateIncidentTeam(String teamId, IncidentTeamUpdateRequest body) throws ApiException {
        return this.updateIncidentTeamWithHttpInfo(teamId, body).getData();
    }

    @Deprecated
    public CompletableFuture<IncidentTeamResponse> updateIncidentTeamAsync(String teamId, IncidentTeamUpdateRequest body) {
        return this.updateIncidentTeamWithHttpInfoAsync(teamId, body).thenApply(response -> (IncidentTeamResponse)response.getData());
    }

    @Deprecated
    public ApiResponse<IncidentTeamResponse> updateIncidentTeamWithHttpInfo(String teamId, IncidentTeamUpdateRequest body) throws ApiException {
        String operationId = "updateIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateIncidentTeam");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.updateIncidentTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamResponse>(){});
    }

    @Deprecated
    public CompletableFuture<ApiResponse<IncidentTeamResponse>> updateIncidentTeamWithHttpInfoAsync(String teamId, IncidentTeamUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "updateIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        IncidentTeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling updateIncidentTeam"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentTeam"));
            return result;
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.IncidentTeamsApi.updateIncidentTeam", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentTeamResponse>> result = new CompletableFuture<ApiResponse<IncidentTeamResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentTeamResponse>(){});
    }

    public static class ListIncidentTeamsOptionalParameters {
        private IncidentRelatedObject include;
        private Long pageSize;
        private Long pageOffset;
        private String filter;

        public ListIncidentTeamsOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public ListIncidentTeamsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentTeamsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListIncidentTeamsOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class GetIncidentTeamOptionalParameters {
        private IncidentRelatedObject include;

        public GetIncidentTeamOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }
    }
}

