/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Host;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"host_list", "total_matching", "total_returned"})
public class HostListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOST_LIST = "host_list";
    private List<Host> hostList = null;
    public static final String JSON_PROPERTY_TOTAL_MATCHING = "total_matching";
    private Long totalMatching;
    public static final String JSON_PROPERTY_TOTAL_RETURNED = "total_returned";
    private Long totalReturned;
    private Map<String, Object> additionalProperties;

    public HostListResponse hostList(List<Host> hostList) {
        this.hostList = hostList;
        for (Host item : hostList) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HostListResponse addHostListItem(Host hostListItem) {
        if (this.hostList == null) {
            this.hostList = new ArrayList<Host>();
        }
        this.hostList.add(hostListItem);
        this.unparsed |= hostListItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="host_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Host> getHostList() {
        return this.hostList;
    }

    public void setHostList(List<Host> hostList) {
        this.hostList = hostList;
    }

    public HostListResponse totalMatching(Long totalMatching) {
        this.totalMatching = totalMatching;
        return this;
    }

    @Nullable
    @JsonProperty(value="total_matching")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalMatching() {
        return this.totalMatching;
    }

    public void setTotalMatching(Long totalMatching) {
        this.totalMatching = totalMatching;
    }

    public HostListResponse totalReturned(Long totalReturned) {
        this.totalReturned = totalReturned;
        return this;
    }

    @Nullable
    @JsonProperty(value="total_returned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalReturned() {
        return this.totalReturned;
    }

    public void setTotalReturned(Long totalReturned) {
        this.totalReturned = totalReturned;
    }

    @JsonAnySetter
    public HostListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostListResponse hostListResponse = (HostListResponse)o;
        return Objects.equals(this.hostList, hostListResponse.hostList) && Objects.equals(this.totalMatching, hostListResponse.totalMatching) && Objects.equals(this.totalReturned, hostListResponse.totalReturned) && Objects.equals(this.additionalProperties, hostListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hostList, this.totalMatching, this.totalReturned, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostListResponse {\n");
        sb.append("    hostList: ").append(this.toIndentedString(this.hostList)).append("\n");
        sb.append("    totalMatching: ").append(this.toIndentedString(this.totalMatching)).append("\n");
        sb.append("    totalReturned: ").append(this.toIndentedString(this.totalReturned)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

