/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Log;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"logs", "nextLogId", "status"})
public class LogsListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_LOGS = "logs";
    private List<Log> logs = null;
    public static final String JSON_PROPERTY_NEXT_LOG_ID = "nextLogId";
    private JsonNullable<String> nextLogId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    private Map<String, Object> additionalProperties;

    public LogsListResponse logs(List<Log> logs) {
        this.logs = logs;
        for (Log item : logs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsListResponse addLogsItem(Log logsItem) {
        if (this.logs == null) {
            this.logs = new ArrayList<Log>();
        }
        this.logs.add(logsItem);
        this.unparsed |= logsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="logs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Log> getLogs() {
        return this.logs;
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public LogsListResponse nextLogId(String nextLogId) {
        this.nextLogId = JsonNullable.of((Object)nextLogId);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getNextLogId() {
        return (String)this.nextLogId.orElse(null);
    }

    @JsonProperty(value="nextLogId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNextLogId_JsonNullable() {
        return this.nextLogId;
    }

    @JsonProperty(value="nextLogId")
    public void setNextLogId_JsonNullable(JsonNullable<String> nextLogId) {
        this.nextLogId = nextLogId;
    }

    public void setNextLogId(String nextLogId) {
        this.nextLogId = JsonNullable.of((Object)nextLogId);
    }

    public LogsListResponse status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonAnySetter
    public LogsListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListResponse logsListResponse = (LogsListResponse)o;
        return Objects.equals(this.logs, logsListResponse.logs) && Objects.equals(this.nextLogId, logsListResponse.nextLogId) && Objects.equals(this.status, logsListResponse.status) && Objects.equals(this.additionalProperties, logsListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.logs, this.nextLogId, this.status, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListResponse {\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("    nextLogId: ").append(this.toIndentedString(this.nextLogId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

