/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.QueryFormula;
import com.datadog.api.client.v2.model.TimeseriesQuery;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"formulas", "from", "interval", "queries", "to"})
public class TimeseriesFormulaRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<QueryFormula> formulas = null;
    public static final String JSON_PROPERTY_FROM = "from";
    private Long from;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Long interval;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<TimeseriesQuery> queries = new ArrayList<TimeseriesQuery>();
    public static final String JSON_PROPERTY_TO = "to";
    private Long to;
    private Map<String, Object> additionalProperties;

    public TimeseriesFormulaRequestAttributes() {
    }

    @JsonCreator
    public TimeseriesFormulaRequestAttributes(@JsonProperty(required=true, value="from") Long from, @JsonProperty(required=true, value="queries") List<TimeseriesQuery> queries, @JsonProperty(required=true, value="to") Long to) {
        this.from = from;
        this.queries = queries;
        this.to = to;
    }

    public TimeseriesFormulaRequestAttributes formulas(List<QueryFormula> formulas) {
        this.formulas = formulas;
        for (QueryFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TimeseriesFormulaRequestAttributes addFormulasItem(QueryFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<QueryFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QueryFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<QueryFormula> formulas) {
        this.formulas = formulas;
    }

    public TimeseriesFormulaRequestAttributes from(Long from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getFrom() {
        return this.from;
    }

    public void setFrom(Long from) {
        this.from = from;
    }

    public TimeseriesFormulaRequestAttributes interval(Long interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public TimeseriesFormulaRequestAttributes queries(List<TimeseriesQuery> queries) {
        this.queries = queries;
        for (TimeseriesQuery item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TimeseriesFormulaRequestAttributes addQueriesItem(TimeseriesQuery queriesItem) {
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TimeseriesQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<TimeseriesQuery> queries) {
        this.queries = queries;
    }

    public TimeseriesFormulaRequestAttributes to(Long to) {
        this.to = to;
        return this;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTo() {
        return this.to;
    }

    public void setTo(Long to) {
        this.to = to;
    }

    @JsonAnySetter
    public TimeseriesFormulaRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesFormulaRequestAttributes timeseriesFormulaRequestAttributes = (TimeseriesFormulaRequestAttributes)o;
        return Objects.equals(this.formulas, timeseriesFormulaRequestAttributes.formulas) && Objects.equals(this.from, timeseriesFormulaRequestAttributes.from) && Objects.equals(this.interval, timeseriesFormulaRequestAttributes.interval) && Objects.equals(this.queries, timeseriesFormulaRequestAttributes.queries) && Objects.equals(this.to, timeseriesFormulaRequestAttributes.to) && Objects.equals(this.additionalProperties, timeseriesFormulaRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.formulas, this.from, this.interval, this.queries, this.to, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeseriesFormulaRequestAttributes {\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

