/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsStorageTier;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"from", "indexes", "query", "storage_tier", "to"})
public class LogsQueryFilter {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FROM = "from";
    private String from = "now-15m";
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query = "*";
    public static final String JSON_PROPERTY_STORAGE_TIER = "storage_tier";
    private LogsStorageTier storageTier = LogsStorageTier.INDEXES;
    public static final String JSON_PROPERTY_TO = "to";
    private String to = "now";
    private Map<String, Object> additionalProperties;

    public LogsQueryFilter from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public LogsQueryFilter indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public LogsQueryFilter addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public LogsQueryFilter query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsQueryFilter storageTier(LogsStorageTier storageTier) {
        this.storageTier = storageTier;
        this.unparsed |= !storageTier.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="storage_tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsStorageTier getStorageTier() {
        return this.storageTier;
    }

    public void setStorageTier(LogsStorageTier storageTier) {
        if (!storageTier.isValid()) {
            this.unparsed = true;
        }
        this.storageTier = storageTier;
    }

    public LogsQueryFilter to(String to) {
        this.to = to;
        return this;
    }

    @Nullable
    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @JsonAnySetter
    public LogsQueryFilter putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsQueryFilter logsQueryFilter = (LogsQueryFilter)o;
        return Objects.equals(this.from, logsQueryFilter.from) && Objects.equals(this.indexes, logsQueryFilter.indexes) && Objects.equals(this.query, logsQueryFilter.query) && Objects.equals(this.storageTier, logsQueryFilter.storageTier) && Objects.equals(this.to, logsQueryFilter.to) && Objects.equals(this.additionalProperties, logsQueryFilter.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.indexes, this.query, this.storageTier, this.to, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsQueryFilter {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    storageTier: ").append(this.toIndentedString(this.storageTier)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

