/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.TableWidgetDefinitionType;
import com.datadog.api.client.v1.model.TableWidgetHasSearchBar;
import com.datadog.api.client.v1.model.TableWidgetRequest;
import com.datadog.api.client.v1.model.WidgetCustomLink;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"custom_links", "has_search_bar", "requests", "time", "title", "title_align", "title_size", "type"})
public class TableWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_HAS_SEARCH_BAR = "has_search_bar";
    private TableWidgetHasSearchBar hasSearchBar;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<TableWidgetRequest> requests = new ArrayList<TableWidgetRequest>();
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TableWidgetDefinitionType type = TableWidgetDefinitionType.QUERY_TABLE;
    private Map<String, Object> additionalProperties;

    public TableWidgetDefinition() {
    }

    @JsonCreator
    public TableWidgetDefinition(@JsonProperty(required=true, value="requests") List<TableWidgetRequest> requests, @JsonProperty(required=true, value="type") TableWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public TableWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TableWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public TableWidgetDefinition hasSearchBar(TableWidgetHasSearchBar hasSearchBar) {
        this.hasSearchBar = hasSearchBar;
        this.unparsed |= !hasSearchBar.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="has_search_bar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableWidgetHasSearchBar getHasSearchBar() {
        return this.hasSearchBar;
    }

    public void setHasSearchBar(TableWidgetHasSearchBar hasSearchBar) {
        if (!hasSearchBar.isValid()) {
            this.unparsed = true;
        }
        this.hasSearchBar = hasSearchBar;
    }

    public TableWidgetDefinition requests(List<TableWidgetRequest> requests) {
        this.requests = requests;
        for (TableWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TableWidgetDefinition addRequestsItem(TableWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TableWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<TableWidgetRequest> requests) {
        this.requests = requests;
    }

    public TableWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public TableWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TableWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public TableWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public TableWidgetDefinition type(TableWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TableWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(TableWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public TableWidgetDefinition putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableWidgetDefinition tableWidgetDefinition = (TableWidgetDefinition)o;
        return Objects.equals(this.customLinks, tableWidgetDefinition.customLinks) && Objects.equals(this.hasSearchBar, tableWidgetDefinition.hasSearchBar) && Objects.equals(this.requests, tableWidgetDefinition.requests) && Objects.equals(this.time, tableWidgetDefinition.time) && Objects.equals(this.title, tableWidgetDefinition.title) && Objects.equals(this.titleAlign, tableWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, tableWidgetDefinition.titleSize) && Objects.equals(this.type, tableWidgetDefinition.type) && Objects.equals(this.additionalProperties, tableWidgetDefinition.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.hasSearchBar, this.requests, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    hasSearchBar: ").append(this.toIndentedString(this.hasSearchBar)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

