/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Creator;
import com.datadog.api.client.v1.model.SyntheticsStep;
import com.datadog.api.client.v1.model.SyntheticsTestConfig;
import com.datadog.api.client.v1.model.SyntheticsTestDetailsSubType;
import com.datadog.api.client.v1.model.SyntheticsTestDetailsType;
import com.datadog.api.client.v1.model.SyntheticsTestOptions;
import com.datadog.api.client.v1.model.SyntheticsTestPauseStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"config", "creator", "locations", "message", "monitor_id", "name", "options", "public_id", "status", "steps", "subtype", "tags", "type"})
public class SyntheticsTestDetails {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private SyntheticsTestConfig config;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<String> locations = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MONITOR_ID = "monitor_id";
    private Long monitorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SyntheticsTestOptions options;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SyntheticsTestPauseStatus status;
    public static final String JSON_PROPERTY_STEPS = "steps";
    private List<SyntheticsStep> steps = null;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private SyntheticsTestDetailsSubType subtype;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsTestDetailsType type;
    private Map<String, Object> additionalProperties;

    public SyntheticsTestDetails config(SyntheticsTestConfig config) {
        this.config = config;
        this.unparsed |= config.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestConfig getConfig() {
        return this.config;
    }

    public void setConfig(SyntheticsTestConfig config) {
        this.config = config;
    }

    @Nullable
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public SyntheticsTestDetails locations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public SyntheticsTestDetails addLocationsItem(String locationsItem) {
        if (this.locations == null) {
            this.locations = new ArrayList<String>();
        }
        this.locations.add(locationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public SyntheticsTestDetails message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @JsonProperty(value="monitor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorId() {
        return this.monitorId;
    }

    public SyntheticsTestDetails name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsTestDetails options(SyntheticsTestOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptions getOptions() {
        return this.options;
    }

    public void setOptions(SyntheticsTestOptions options) {
        this.options = options;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public SyntheticsTestDetails status(SyntheticsTestPauseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestPauseStatus getStatus() {
        return this.status;
    }

    public void setStatus(SyntheticsTestPauseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public SyntheticsTestDetails steps(List<SyntheticsStep> steps) {
        this.steps = steps;
        for (SyntheticsStep item : steps) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTestDetails addStepsItem(SyntheticsStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<SyntheticsStep>();
        }
        this.steps.add(stepsItem);
        this.unparsed |= stepsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="steps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<SyntheticsStep> steps) {
        this.steps = steps;
    }

    public SyntheticsTestDetails subtype(SyntheticsTestDetailsSubType subtype) {
        this.subtype = subtype;
        this.unparsed |= !subtype.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestDetailsSubType getSubtype() {
        return this.subtype;
    }

    public void setSubtype(SyntheticsTestDetailsSubType subtype) {
        if (!subtype.isValid()) {
            this.unparsed = true;
        }
        this.subtype = subtype;
    }

    public SyntheticsTestDetails tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsTestDetails addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SyntheticsTestDetails type(SyntheticsTestDetailsType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestDetailsType getType() {
        return this.type;
    }

    public void setType(SyntheticsTestDetailsType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public SyntheticsTestDetails putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestDetails syntheticsTestDetails = (SyntheticsTestDetails)o;
        return Objects.equals(this.config, syntheticsTestDetails.config) && Objects.equals(this.creator, syntheticsTestDetails.creator) && Objects.equals(this.locations, syntheticsTestDetails.locations) && Objects.equals(this.message, syntheticsTestDetails.message) && Objects.equals(this.monitorId, syntheticsTestDetails.monitorId) && Objects.equals(this.name, syntheticsTestDetails.name) && Objects.equals(this.options, syntheticsTestDetails.options) && Objects.equals(this.publicId, syntheticsTestDetails.publicId) && Objects.equals(this.status, syntheticsTestDetails.status) && Objects.equals(this.steps, syntheticsTestDetails.steps) && Objects.equals(this.subtype, syntheticsTestDetails.subtype) && Objects.equals(this.tags, syntheticsTestDetails.tags) && Objects.equals(this.type, syntheticsTestDetails.type) && Objects.equals(this.additionalProperties, syntheticsTestDetails.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.creator, this.locations, this.message, this.monitorId, this.name, this.options, this.publicId, this.status, this.steps, this.subtype, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestDetails {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    monitorId: ").append(this.toIndentedString(this.monitorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

