/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SplitConfigSortCompute;
import com.datadog.api.client.v1.model.WidgetSort;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "order"})
public class SplitSort {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private SplitConfigSortCompute compute;
    public static final String JSON_PROPERTY_ORDER = "order";
    private WidgetSort order;
    private Map<String, Object> additionalProperties;

    public SplitSort() {
    }

    @JsonCreator
    public SplitSort(@JsonProperty(required=true, value="order") WidgetSort order) {
        this.order = order;
        this.unparsed |= !order.isValid();
    }

    public SplitSort compute(SplitConfigSortCompute compute) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SplitConfigSortCompute getCompute() {
        return this.compute;
    }

    public void setCompute(SplitConfigSortCompute compute) {
        this.compute = compute;
    }

    public SplitSort order(WidgetSort order) {
        this.order = order;
        this.unparsed |= !order.isValid();
        return this;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetSort getOrder() {
        return this.order;
    }

    public void setOrder(WidgetSort order) {
        if (!order.isValid()) {
            this.unparsed = true;
        }
        this.order = order;
    }

    @JsonAnySetter
    public SplitSort putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitSort splitSort = (SplitSort)o;
        return Objects.equals(this.compute, splitSort.compute) && Objects.equals(this.order, splitSort.order) && Objects.equals(this.additionalProperties, splitSort.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.order, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitSort {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

