/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SplitDimension;
import com.datadog.api.client.v1.model.SplitSort;
import com.datadog.api.client.v1.model.SplitVectorEntryItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"limit", "sort", "split_dimensions", "static_splits"})
public class SplitConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Long limit;
    public static final String JSON_PROPERTY_SORT = "sort";
    private SplitSort sort;
    public static final String JSON_PROPERTY_SPLIT_DIMENSIONS = "split_dimensions";
    private List<SplitDimension> splitDimensions = new ArrayList<SplitDimension>();
    public static final String JSON_PROPERTY_STATIC_SPLITS = "static_splits";
    private List<List<SplitVectorEntryItem>> staticSplits = null;
    private Map<String, Object> additionalProperties;

    public SplitConfig() {
    }

    @JsonCreator
    public SplitConfig(@JsonProperty(required=true, value="limit") Long limit, @JsonProperty(required=true, value="sort") SplitSort sort, @JsonProperty(required=true, value="split_dimensions") List<SplitDimension> splitDimensions) {
        this.limit = limit;
        this.sort = sort;
        this.unparsed |= sort.unparsed;
        this.splitDimensions = splitDimensions;
    }

    public SplitConfig limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public SplitConfig sort(SplitSort sort) {
        this.sort = sort;
        this.unparsed |= sort.unparsed;
        return this;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SplitSort getSort() {
        return this.sort;
    }

    public void setSort(SplitSort sort) {
        this.sort = sort;
    }

    public SplitConfig splitDimensions(List<SplitDimension> splitDimensions) {
        this.splitDimensions = splitDimensions;
        for (SplitDimension item : splitDimensions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SplitConfig addSplitDimensionsItem(SplitDimension splitDimensionsItem) {
        this.splitDimensions.add(splitDimensionsItem);
        this.unparsed |= splitDimensionsItem.unparsed;
        return this;
    }

    @JsonProperty(value="split_dimensions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SplitDimension> getSplitDimensions() {
        return this.splitDimensions;
    }

    public void setSplitDimensions(List<SplitDimension> splitDimensions) {
        this.splitDimensions = splitDimensions;
    }

    public SplitConfig staticSplits(List<List<SplitVectorEntryItem>> staticSplits) {
        this.staticSplits = staticSplits;
        return this;
    }

    public SplitConfig addStaticSplitsItem(List<SplitVectorEntryItem> staticSplitsItem) {
        if (this.staticSplits == null) {
            this.staticSplits = new ArrayList<List<SplitVectorEntryItem>>();
        }
        this.staticSplits.add(staticSplitsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="static_splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<SplitVectorEntryItem>> getStaticSplits() {
        return this.staticSplits;
    }

    public void setStaticSplits(List<List<SplitVectorEntryItem>> staticSplits) {
        this.staticSplits = staticSplits;
    }

    @JsonAnySetter
    public SplitConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitConfig splitConfig = (SplitConfig)o;
        return Objects.equals(this.limit, splitConfig.limit) && Objects.equals(this.sort, splitConfig.sort) && Objects.equals(this.splitDimensions, splitConfig.splitDimensions) && Objects.equals(this.staticSplits, splitConfig.staticSplits) && Objects.equals(this.additionalProperties, splitConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.sort, this.splitDimensions, this.staticSplits, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitConfig {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    splitDimensions: ").append(this.toIndentedString(this.splitDimensions)).append("\n");
        sb.append("    staticSplits: ").append(this.toIndentedString(this.staticSplits)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

