/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client;

import com.datadog.api.client.PaginationIterable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public class PaginationIterator<T>
implements Iterator<T> {
    private int currentIndex = 0;
    private int totalCount = 0;
    private Boolean hasNextPage;
    private ArrayList data;
    private PaginationIterable iterable;
    private Method requestMethod;

    PaginationIterator(PaginationIterable iterable) {
        this.iterable = iterable;
        this.requestMethod = this.buildRequestMethod();
        this.getNextPage();
    }

    private Method buildRequestMethod() {
        Method[] methods;
        for (Method m : methods = this.iterable.requestClass.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(this.iterable.requestName) || m.getParameterTypes().length != this.iterable.args.keySet().size()) continue;
            m.setAccessible(true);
            return m;
        }
        throw new RuntimeException("Unable to find request method " + this.iterable.requestName);
    }

    private void setNextPageValue(Object response) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int i;
        Object temp;
        Object value = response;
        if (this.iterable.valueSetterParamOptional.booleanValue()) {
            temp = this.iterable.args.get("optionalParams");
            i = 0;
        } else {
            temp = this.iterable.args.get(this.iterable.valueSetterPath[0]);
            i = 1;
        }
        while (i < this.iterable.valueSetterPath.length - 1) {
            try {
                Field f = temp.getClass().getDeclaredField(this.iterable.valueSetterPath[i]);
                f.setAccessible(true);
                temp = f.get(temp);
            }
            catch (Exception e) {
                temp = temp.getClass().getMethod(this.iterable.valueSetterPath[i], new Class[0]).invoke(temp, new Object[0]);
            }
            ++i;
        }
        Method setterMethod = null;
        for (Method m : temp.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(this.iterable.valueSetterPath[i])) continue;
            setterMethod = m;
            break;
        }
        assert (setterMethod != null);
        if (this.iterable.valueGetterPath.length > 0) {
            for (String path : this.iterable.valueGetterPath) {
                value = value.getClass().getMethod(path, new Class[0]).invoke(value, new Object[0]);
            }
        } else {
            String pType = setterMethod.getParameterTypes()[0].getSimpleName();
            value = "Long".equals(pType) ? (Number)Long.valueOf(this.totalCount) : (Number)this.totalCount;
        }
        setterMethod.invoke(temp, value);
        this.hasNextPage = true;
    }

    private void getNextPage() {
        Object response;
        try {
            Object resultData = response = this.requestMethod.invoke(this.iterable.requestClass, this.iterable.args.values().toArray());
            if (this.iterable.resultsPath != null) {
                for (String path : this.iterable.resultsPath) {
                    resultData = resultData.getClass().getMethod(path, new Class[0]).invoke(resultData, new Object[0]);
                }
            }
            this.data = (ArrayList)resultData;
            this.totalCount = this.iterable.offsetPageIncrement.booleanValue() ? (this.totalCount += this.data.size()) : ++this.totalCount;
            this.currentIndex = 0;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to preload results: " + e.getMessage(), e);
        }
        try {
            this.setNextPageValue(response);
        }
        catch (Exception e) {
            this.hasNextPage = false;
        }
    }

    private static int convertToInt(Object arg) {
        if ("Long".equals(arg.getClass().getSimpleName())) {
            long value = Long.parseLong(arg.toString());
            return (int)value;
        }
        return (Integer)arg;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex < this.data.size()) {
            return true;
        }
        if (this.data.size() < PaginationIterator.convertToInt(this.iterable.limit)) {
            return false;
        }
        if (this.hasNextPage.booleanValue()) {
            this.getNextPage();
            return this.data.size() != 0;
        }
        return false;
    }

    @Override
    public T next() {
        ++this.currentIndex;
        return (T)this.data.get(this.currentIndex - 1);
    }
}

