/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.GCPAccount;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class GcpIntegrationApi {
    private ApiClient apiClient;

    public GcpIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public GcpIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Object createGCPIntegration(GCPAccount body) throws ApiException {
        return this.createGCPIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> createGCPIntegrationAsync(GCPAccount body) {
        return this.createGCPIntegrationWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> createGCPIntegrationWithHttpInfo(GCPAccount body) throws ApiException {
        GCPAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGCPIntegration");
        }
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.GcpIntegrationApi.createGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> createGCPIntegrationWithHttpInfoAsync(GCPAccount body) {
        Invocation.Builder builder;
        GCPAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createGCPIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("GcpIntegrationApi.createGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public Object deleteGCPIntegration(GCPAccount body) throws ApiException {
        return this.deleteGCPIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> deleteGCPIntegrationAsync(GCPAccount body) {
        return this.deleteGCPIntegrationWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> deleteGCPIntegrationWithHttpInfo(GCPAccount body) throws ApiException {
        GCPAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteGCPIntegration");
        }
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.GcpIntegrationApi.deleteGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> deleteGCPIntegrationWithHttpInfoAsync(GCPAccount body) {
        Invocation.Builder builder;
        GCPAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteGCPIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("GcpIntegrationApi.deleteGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public List<GCPAccount> listGCPIntegration() throws ApiException {
        return this.listGCPIntegrationWithHttpInfo().getData();
    }

    public CompletableFuture<List<GCPAccount>> listGCPIntegrationAsync() {
        return this.listGCPIntegrationWithHttpInfoAsync().thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<GCPAccount>> listGCPIntegrationWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.GcpIntegrationApi.listGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<GCPAccount>>(){});
    }

    public CompletableFuture<ApiResponse<List<GCPAccount>>> listGCPIntegrationWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("GcpIntegrationApi.listGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<GCPAccount>>> result = new CompletableFuture<ApiResponse<List<GCPAccount>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<GCPAccount>>(){});
    }

    public Object updateGCPIntegration(GCPAccount body) throws ApiException {
        return this.updateGCPIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> updateGCPIntegrationAsync(GCPAccount body) {
        return this.updateGCPIntegrationWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> updateGCPIntegrationWithHttpInfo(GCPAccount body) throws ApiException {
        GCPAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGCPIntegration");
        }
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.GcpIntegrationApi.updateGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> updateGCPIntegrationWithHttpInfoAsync(GCPAccount body) {
        Invocation.Builder builder;
        GCPAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateGCPIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/gcp";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("GcpIntegrationApi.updateGCPIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }
}

