/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CloudConfigurationComplianceRuleOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleDetectionMethod;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleEvaluationWindow;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleHardcodedEvaluatorType;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleImpossibleTravelOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleKeepAlive;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleMaxSignalDuration;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleNewValueOptions;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"complianceRuleOptions", "decreaseCriticalityBasedOnEnv", "detectionMethod", "evaluationWindow", "hardcodedEvaluatorType", "impossibleTravelOptions", "keepAlive", "maxSignalDuration", "newValueOptions"})
public class SecurityMonitoringRuleOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPLIANCE_RULE_OPTIONS = "complianceRuleOptions";
    private CloudConfigurationComplianceRuleOptions complianceRuleOptions;
    public static final String JSON_PROPERTY_DECREASE_CRITICALITY_BASED_ON_ENV = "decreaseCriticalityBasedOnEnv";
    private Boolean decreaseCriticalityBasedOnEnv;
    public static final String JSON_PROPERTY_DETECTION_METHOD = "detectionMethod";
    private SecurityMonitoringRuleDetectionMethod detectionMethod;
    public static final String JSON_PROPERTY_EVALUATION_WINDOW = "evaluationWindow";
    private SecurityMonitoringRuleEvaluationWindow evaluationWindow;
    public static final String JSON_PROPERTY_HARDCODED_EVALUATOR_TYPE = "hardcodedEvaluatorType";
    private SecurityMonitoringRuleHardcodedEvaluatorType hardcodedEvaluatorType;
    public static final String JSON_PROPERTY_IMPOSSIBLE_TRAVEL_OPTIONS = "impossibleTravelOptions";
    private SecurityMonitoringRuleImpossibleTravelOptions impossibleTravelOptions;
    public static final String JSON_PROPERTY_KEEP_ALIVE = "keepAlive";
    private SecurityMonitoringRuleKeepAlive keepAlive;
    public static final String JSON_PROPERTY_MAX_SIGNAL_DURATION = "maxSignalDuration";
    private SecurityMonitoringRuleMaxSignalDuration maxSignalDuration;
    public static final String JSON_PROPERTY_NEW_VALUE_OPTIONS = "newValueOptions";
    private SecurityMonitoringRuleNewValueOptions newValueOptions;
    private Map<String, Object> additionalProperties;

    public SecurityMonitoringRuleOptions complianceRuleOptions(CloudConfigurationComplianceRuleOptions complianceRuleOptions) {
        this.complianceRuleOptions = complianceRuleOptions;
        this.unparsed |= complianceRuleOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="complianceRuleOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CloudConfigurationComplianceRuleOptions getComplianceRuleOptions() {
        return this.complianceRuleOptions;
    }

    public void setComplianceRuleOptions(CloudConfigurationComplianceRuleOptions complianceRuleOptions) {
        this.complianceRuleOptions = complianceRuleOptions;
    }

    public SecurityMonitoringRuleOptions decreaseCriticalityBasedOnEnv(Boolean decreaseCriticalityBasedOnEnv) {
        this.decreaseCriticalityBasedOnEnv = decreaseCriticalityBasedOnEnv;
        return this;
    }

    @Nullable
    @JsonProperty(value="decreaseCriticalityBasedOnEnv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDecreaseCriticalityBasedOnEnv() {
        return this.decreaseCriticalityBasedOnEnv;
    }

    public void setDecreaseCriticalityBasedOnEnv(Boolean decreaseCriticalityBasedOnEnv) {
        this.decreaseCriticalityBasedOnEnv = decreaseCriticalityBasedOnEnv;
    }

    public SecurityMonitoringRuleOptions detectionMethod(SecurityMonitoringRuleDetectionMethod detectionMethod) {
        this.detectionMethod = detectionMethod;
        this.unparsed |= !detectionMethod.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="detectionMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleDetectionMethod getDetectionMethod() {
        return this.detectionMethod;
    }

    public void setDetectionMethod(SecurityMonitoringRuleDetectionMethod detectionMethod) {
        if (!detectionMethod.isValid()) {
            this.unparsed = true;
        }
        this.detectionMethod = detectionMethod;
    }

    public SecurityMonitoringRuleOptions evaluationWindow(SecurityMonitoringRuleEvaluationWindow evaluationWindow) {
        this.evaluationWindow = evaluationWindow;
        this.unparsed |= !evaluationWindow.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleEvaluationWindow getEvaluationWindow() {
        return this.evaluationWindow;
    }

    public void setEvaluationWindow(SecurityMonitoringRuleEvaluationWindow evaluationWindow) {
        if (!evaluationWindow.isValid()) {
            this.unparsed = true;
        }
        this.evaluationWindow = evaluationWindow;
    }

    public SecurityMonitoringRuleOptions hardcodedEvaluatorType(SecurityMonitoringRuleHardcodedEvaluatorType hardcodedEvaluatorType) {
        this.hardcodedEvaluatorType = hardcodedEvaluatorType;
        this.unparsed |= !hardcodedEvaluatorType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="hardcodedEvaluatorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleHardcodedEvaluatorType getHardcodedEvaluatorType() {
        return this.hardcodedEvaluatorType;
    }

    public void setHardcodedEvaluatorType(SecurityMonitoringRuleHardcodedEvaluatorType hardcodedEvaluatorType) {
        if (!hardcodedEvaluatorType.isValid()) {
            this.unparsed = true;
        }
        this.hardcodedEvaluatorType = hardcodedEvaluatorType;
    }

    public SecurityMonitoringRuleOptions impossibleTravelOptions(SecurityMonitoringRuleImpossibleTravelOptions impossibleTravelOptions) {
        this.impossibleTravelOptions = impossibleTravelOptions;
        this.unparsed |= impossibleTravelOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="impossibleTravelOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleImpossibleTravelOptions getImpossibleTravelOptions() {
        return this.impossibleTravelOptions;
    }

    public void setImpossibleTravelOptions(SecurityMonitoringRuleImpossibleTravelOptions impossibleTravelOptions) {
        this.impossibleTravelOptions = impossibleTravelOptions;
    }

    public SecurityMonitoringRuleOptions keepAlive(SecurityMonitoringRuleKeepAlive keepAlive) {
        this.keepAlive = keepAlive;
        this.unparsed |= !keepAlive.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="keepAlive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(SecurityMonitoringRuleKeepAlive keepAlive) {
        if (!keepAlive.isValid()) {
            this.unparsed = true;
        }
        this.keepAlive = keepAlive;
    }

    public SecurityMonitoringRuleOptions maxSignalDuration(SecurityMonitoringRuleMaxSignalDuration maxSignalDuration) {
        this.maxSignalDuration = maxSignalDuration;
        this.unparsed |= !maxSignalDuration.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="maxSignalDuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleMaxSignalDuration getMaxSignalDuration() {
        return this.maxSignalDuration;
    }

    public void setMaxSignalDuration(SecurityMonitoringRuleMaxSignalDuration maxSignalDuration) {
        if (!maxSignalDuration.isValid()) {
            this.unparsed = true;
        }
        this.maxSignalDuration = maxSignalDuration;
    }

    public SecurityMonitoringRuleOptions newValueOptions(SecurityMonitoringRuleNewValueOptions newValueOptions) {
        this.newValueOptions = newValueOptions;
        this.unparsed |= newValueOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="newValueOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleNewValueOptions getNewValueOptions() {
        return this.newValueOptions;
    }

    public void setNewValueOptions(SecurityMonitoringRuleNewValueOptions newValueOptions) {
        this.newValueOptions = newValueOptions;
    }

    @JsonAnySetter
    public SecurityMonitoringRuleOptions putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleOptions securityMonitoringRuleOptions = (SecurityMonitoringRuleOptions)o;
        return Objects.equals(this.complianceRuleOptions, securityMonitoringRuleOptions.complianceRuleOptions) && Objects.equals(this.decreaseCriticalityBasedOnEnv, securityMonitoringRuleOptions.decreaseCriticalityBasedOnEnv) && Objects.equals(this.detectionMethod, securityMonitoringRuleOptions.detectionMethod) && Objects.equals(this.evaluationWindow, securityMonitoringRuleOptions.evaluationWindow) && Objects.equals(this.hardcodedEvaluatorType, securityMonitoringRuleOptions.hardcodedEvaluatorType) && Objects.equals(this.impossibleTravelOptions, securityMonitoringRuleOptions.impossibleTravelOptions) && Objects.equals(this.keepAlive, securityMonitoringRuleOptions.keepAlive) && Objects.equals(this.maxSignalDuration, securityMonitoringRuleOptions.maxSignalDuration) && Objects.equals(this.newValueOptions, securityMonitoringRuleOptions.newValueOptions) && Objects.equals(this.additionalProperties, securityMonitoringRuleOptions.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.complianceRuleOptions, this.decreaseCriticalityBasedOnEnv, this.detectionMethod, this.evaluationWindow, this.hardcodedEvaluatorType, this.impossibleTravelOptions, this.keepAlive, this.maxSignalDuration, this.newValueOptions, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleOptions {\n");
        sb.append("    complianceRuleOptions: ").append(this.toIndentedString(this.complianceRuleOptions)).append("\n");
        sb.append("    decreaseCriticalityBasedOnEnv: ").append(this.toIndentedString(this.decreaseCriticalityBasedOnEnv)).append("\n");
        sb.append("    detectionMethod: ").append(this.toIndentedString(this.detectionMethod)).append("\n");
        sb.append("    evaluationWindow: ").append(this.toIndentedString(this.evaluationWindow)).append("\n");
        sb.append("    hardcodedEvaluatorType: ").append(this.toIndentedString(this.hardcodedEvaluatorType)).append("\n");
        sb.append("    impossibleTravelOptions: ").append(this.toIndentedString(this.impossibleTravelOptions)).append("\n");
        sb.append("    keepAlive: ").append(this.toIndentedString(this.keepAlive)).append("\n");
        sb.append("    maxSignalDuration: ").append(this.toIndentedString(this.maxSignalDuration)).append("\n");
        sb.append("    newValueOptions: ").append(this.toIndentedString(this.newValueOptions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

