/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentSearchResponseFacetsData;
import com.datadog.api.client.v2.model.IncidentSearchResponseIncidentsData;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"facets", "incidents", "total"})
public class IncidentSearchResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FACETS = "facets";
    private IncidentSearchResponseFacetsData facets;
    public static final String JSON_PROPERTY_INCIDENTS = "incidents";
    private List<IncidentSearchResponseIncidentsData> incidents = new ArrayList<IncidentSearchResponseIncidentsData>();
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Integer total;
    private Map<String, Object> additionalProperties;

    public IncidentSearchResponseAttributes() {
    }

    @JsonCreator
    public IncidentSearchResponseAttributes(@JsonProperty(required=true, value="facets") IncidentSearchResponseFacetsData facets, @JsonProperty(required=true, value="incidents") List<IncidentSearchResponseIncidentsData> incidents, @JsonProperty(required=true, value="total") Integer total) {
        this.facets = facets;
        this.unparsed |= facets.unparsed;
        this.incidents = incidents;
        this.total = total;
    }

    public IncidentSearchResponseAttributes facets(IncidentSearchResponseFacetsData facets) {
        this.facets = facets;
        this.unparsed |= facets.unparsed;
        return this;
    }

    @JsonProperty(value="facets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentSearchResponseFacetsData getFacets() {
        return this.facets;
    }

    public void setFacets(IncidentSearchResponseFacetsData facets) {
        this.facets = facets;
    }

    public IncidentSearchResponseAttributes incidents(List<IncidentSearchResponseIncidentsData> incidents) {
        this.incidents = incidents;
        for (IncidentSearchResponseIncidentsData item : incidents) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IncidentSearchResponseAttributes addIncidentsItem(IncidentSearchResponseIncidentsData incidentsItem) {
        this.incidents.add(incidentsItem);
        this.unparsed |= incidentsItem.unparsed;
        return this;
    }

    @JsonProperty(value="incidents")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IncidentSearchResponseIncidentsData> getIncidents() {
        return this.incidents;
    }

    public void setIncidents(List<IncidentSearchResponseIncidentsData> incidents) {
        this.incidents = incidents;
    }

    public IncidentSearchResponseAttributes total(Integer total) {
        this.total = total;
        return this;
    }

    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    @JsonAnySetter
    public IncidentSearchResponseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentSearchResponseAttributes incidentSearchResponseAttributes = (IncidentSearchResponseAttributes)o;
        return Objects.equals(this.facets, incidentSearchResponseAttributes.facets) && Objects.equals(this.incidents, incidentSearchResponseAttributes.incidents) && Objects.equals(this.total, incidentSearchResponseAttributes.total) && Objects.equals(this.additionalProperties, incidentSearchResponseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.facets, this.incidents, this.total, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentSearchResponseAttributes {\n");
        sb.append("    facets: ").append(this.toIndentedString(this.facets)).append("\n");
        sb.append("    incidents: ").append(this.toIndentedString(this.incidents)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

