/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.AWSAccount;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accounts"})
public class AWSAccountListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNTS = "accounts";
    private List<AWSAccount> accounts = null;
    private Map<String, Object> additionalProperties;

    public AWSAccountListResponse accounts(List<AWSAccount> accounts) {
        this.accounts = accounts;
        for (AWSAccount item : accounts) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AWSAccountListResponse addAccountsItem(AWSAccount accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<AWSAccount>();
        }
        this.accounts.add(accountsItem);
        this.unparsed |= accountsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AWSAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AWSAccount> accounts) {
        this.accounts = accounts;
    }

    @JsonAnySetter
    public AWSAccountListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccountListResponse awsAccountListResponse = (AWSAccountListResponse)o;
        return Objects.equals(this.accounts, awsAccountListResponse.accounts) && Objects.equals(this.additionalProperties, awsAccountListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccountListResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

