/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.NoteWidgetDefinitionType;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTickEdge;
import com.datadog.api.client.v1.model.WidgetVerticalAlign;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"background_color", "content", "font_size", "has_padding", "show_tick", "text_align", "tick_edge", "tick_pos", "type", "vertical_align"})
public class NoteWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BACKGROUND_COLOR = "background_color";
    private String backgroundColor;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private String content;
    public static final String JSON_PROPERTY_FONT_SIZE = "font_size";
    private String fontSize;
    public static final String JSON_PROPERTY_HAS_PADDING = "has_padding";
    private Boolean hasPadding = true;
    public static final String JSON_PROPERTY_SHOW_TICK = "show_tick";
    private Boolean showTick;
    public static final String JSON_PROPERTY_TEXT_ALIGN = "text_align";
    private WidgetTextAlign textAlign;
    public static final String JSON_PROPERTY_TICK_EDGE = "tick_edge";
    private WidgetTickEdge tickEdge;
    public static final String JSON_PROPERTY_TICK_POS = "tick_pos";
    private String tickPos;
    public static final String JSON_PROPERTY_TYPE = "type";
    private NoteWidgetDefinitionType type = NoteWidgetDefinitionType.NOTE;
    public static final String JSON_PROPERTY_VERTICAL_ALIGN = "vertical_align";
    private WidgetVerticalAlign verticalAlign;

    public NoteWidgetDefinition() {
    }

    @JsonCreator
    public NoteWidgetDefinition(@JsonProperty(required=true, value="content") String content, @JsonProperty(required=true, value="type") NoteWidgetDefinitionType type) {
        this.content = content;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public NoteWidgetDefinition backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Nullable
    @JsonProperty(value="background_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public NoteWidgetDefinition content(String content) {
        this.content = content;
        return this;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public NoteWidgetDefinition fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="font_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public NoteWidgetDefinition hasPadding(Boolean hasPadding) {
        this.hasPadding = hasPadding;
        return this;
    }

    @Nullable
    @JsonProperty(value="has_padding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPadding() {
        return this.hasPadding;
    }

    public void setHasPadding(Boolean hasPadding) {
        this.hasPadding = hasPadding;
    }

    public NoteWidgetDefinition showTick(Boolean showTick) {
        this.showTick = showTick;
        return this;
    }

    @Nullable
    @JsonProperty(value="show_tick")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTick() {
        return this.showTick;
    }

    public void setShowTick(Boolean showTick) {
        this.showTick = showTick;
    }

    public NoteWidgetDefinition textAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
        this.unparsed |= !textAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="text_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(WidgetTextAlign textAlign) {
        if (!textAlign.isValid()) {
            this.unparsed = true;
        }
        this.textAlign = textAlign;
    }

    public NoteWidgetDefinition tickEdge(WidgetTickEdge tickEdge) {
        this.tickEdge = tickEdge;
        this.unparsed |= !tickEdge.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="tick_edge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTickEdge getTickEdge() {
        return this.tickEdge;
    }

    public void setTickEdge(WidgetTickEdge tickEdge) {
        if (!tickEdge.isValid()) {
            this.unparsed = true;
        }
        this.tickEdge = tickEdge;
    }

    public NoteWidgetDefinition tickPos(String tickPos) {
        this.tickPos = tickPos;
        return this;
    }

    @Nullable
    @JsonProperty(value="tick_pos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTickPos() {
        return this.tickPos;
    }

    public void setTickPos(String tickPos) {
        this.tickPos = tickPos;
    }

    public NoteWidgetDefinition type(NoteWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NoteWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(NoteWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public NoteWidgetDefinition verticalAlign(WidgetVerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
        this.unparsed |= !verticalAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="vertical_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetVerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(WidgetVerticalAlign verticalAlign) {
        if (!verticalAlign.isValid()) {
            this.unparsed = true;
        }
        this.verticalAlign = verticalAlign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteWidgetDefinition noteWidgetDefinition = (NoteWidgetDefinition)o;
        return Objects.equals(this.backgroundColor, noteWidgetDefinition.backgroundColor) && Objects.equals(this.content, noteWidgetDefinition.content) && Objects.equals(this.fontSize, noteWidgetDefinition.fontSize) && Objects.equals(this.hasPadding, noteWidgetDefinition.hasPadding) && Objects.equals(this.showTick, noteWidgetDefinition.showTick) && Objects.equals(this.textAlign, noteWidgetDefinition.textAlign) && Objects.equals(this.tickEdge, noteWidgetDefinition.tickEdge) && Objects.equals(this.tickPos, noteWidgetDefinition.tickPos) && Objects.equals(this.type, noteWidgetDefinition.type) && Objects.equals(this.verticalAlign, noteWidgetDefinition.verticalAlign);
    }

    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.content, this.fontSize, this.hasPadding, this.showTick, this.textAlign, this.tickEdge, this.tickPos, this.type, this.verticalAlign);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NoteWidgetDefinition {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    hasPadding: ").append(this.toIndentedString(this.hasPadding)).append("\n");
        sb.append("    showTick: ").append(this.toIndentedString(this.showTick)).append("\n");
        sb.append("    textAlign: ").append(this.toIndentedString(this.textAlign)).append("\n");
        sb.append("    tickEdge: ").append(this.toIndentedString(this.tickEdge)).append("\n");
        sb.append("    tickPos: ").append(this.toIndentedString(this.tickPos)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    verticalAlign: ").append(this.toIndentedString(this.verticalAlign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

