/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringSignalArchiveReason;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"archive_comment", "archive_reason", "state", "version"})
public class SecurityMonitoringSignalStateUpdateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ARCHIVE_COMMENT = "archive_comment";
    private String archiveComment;
    public static final String JSON_PROPERTY_ARCHIVE_REASON = "archive_reason";
    private SecurityMonitoringSignalArchiveReason archiveReason;
    public static final String JSON_PROPERTY_STATE = "state";
    private SecurityMonitoringSignalState state;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;

    public SecurityMonitoringSignalStateUpdateAttributes() {
    }

    @JsonCreator
    public SecurityMonitoringSignalStateUpdateAttributes(@JsonProperty(required=true, value="state") SecurityMonitoringSignalState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
    }

    public SecurityMonitoringSignalStateUpdateAttributes archiveComment(String archiveComment) {
        this.archiveComment = archiveComment;
        return this;
    }

    @Nullable
    @JsonProperty(value="archive_comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchiveComment() {
        return this.archiveComment;
    }

    public void setArchiveComment(String archiveComment) {
        this.archiveComment = archiveComment;
    }

    public SecurityMonitoringSignalStateUpdateAttributes archiveReason(SecurityMonitoringSignalArchiveReason archiveReason) {
        this.archiveReason = archiveReason;
        this.unparsed |= !archiveReason.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="archive_reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringSignalArchiveReason getArchiveReason() {
        return this.archiveReason;
    }

    public void setArchiveReason(SecurityMonitoringSignalArchiveReason archiveReason) {
        if (!archiveReason.isValid()) {
            this.unparsed = true;
        }
        this.archiveReason = archiveReason;
    }

    public SecurityMonitoringSignalStateUpdateAttributes state(SecurityMonitoringSignalState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityMonitoringSignalState getState() {
        return this.state;
    }

    public void setState(SecurityMonitoringSignalState state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    public SecurityMonitoringSignalStateUpdateAttributes version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringSignalStateUpdateAttributes securityMonitoringSignalStateUpdateAttributes = (SecurityMonitoringSignalStateUpdateAttributes)o;
        return Objects.equals(this.archiveComment, securityMonitoringSignalStateUpdateAttributes.archiveComment) && Objects.equals(this.archiveReason, securityMonitoringSignalStateUpdateAttributes.archiveReason) && Objects.equals(this.state, securityMonitoringSignalStateUpdateAttributes.state) && Objects.equals(this.version, securityMonitoringSignalStateUpdateAttributes.version);
    }

    public int hashCode() {
        return Objects.hash(this.archiveComment, this.archiveReason, this.state, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringSignalStateUpdateAttributes {\n");
        sb.append("    archiveComment: ").append(this.toIndentedString(this.archiveComment)).append("\n");
        sb.append("    archiveReason: ").append(this.toIndentedString(this.archiveReason)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

