/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SearchSLOTimeframe;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"target", "target_display", "timeframe", "warning", "warning_display"})
public class SearchSLOThreshold {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TARGET = "target";
    private Double target;
    public static final String JSON_PROPERTY_TARGET_DISPLAY = "target_display";
    private String targetDisplay;
    public static final String JSON_PROPERTY_TIMEFRAME = "timeframe";
    private SearchSLOTimeframe timeframe;
    public static final String JSON_PROPERTY_WARNING = "warning";
    private JsonNullable<Double> warning = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WARNING_DISPLAY = "warning_display";
    private JsonNullable<String> warningDisplay = JsonNullable.undefined();

    public SearchSLOThreshold() {
    }

    @JsonCreator
    public SearchSLOThreshold(@JsonProperty(required=true, value="target") Double target, @JsonProperty(required=true, value="timeframe") SearchSLOTimeframe timeframe) {
        this.target = target;
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
    }

    public SearchSLOThreshold target(Double target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getTarget() {
        return this.target;
    }

    public void setTarget(Double target) {
        this.target = target;
    }

    public SearchSLOThreshold targetDisplay(String targetDisplay) {
        this.targetDisplay = targetDisplay;
        return this;
    }

    @Nullable
    @JsonProperty(value="target_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetDisplay() {
        return this.targetDisplay;
    }

    public void setTargetDisplay(String targetDisplay) {
        this.targetDisplay = targetDisplay;
    }

    public SearchSLOThreshold timeframe(SearchSLOTimeframe timeframe) {
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
        return this;
    }

    @JsonProperty(value="timeframe")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SearchSLOTimeframe getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(SearchSLOTimeframe timeframe) {
        if (!timeframe.isValid()) {
            this.unparsed = true;
        }
        this.timeframe = timeframe;
    }

    public SearchSLOThreshold warning(Double warning) {
        this.warning = JsonNullable.of((Object)warning);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Double getWarning() {
        return (Double)this.warning.orElse(null);
    }

    @JsonProperty(value="warning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Double> getWarning_JsonNullable() {
        return this.warning;
    }

    @JsonProperty(value="warning")
    public void setWarning_JsonNullable(JsonNullable<Double> warning) {
        this.warning = warning;
    }

    public void setWarning(Double warning) {
        this.warning = JsonNullable.of((Object)warning);
    }

    public SearchSLOThreshold warningDisplay(String warningDisplay) {
        this.warningDisplay = JsonNullable.of((Object)warningDisplay);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getWarningDisplay() {
        return (String)this.warningDisplay.orElse(null);
    }

    @JsonProperty(value="warning_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getWarningDisplay_JsonNullable() {
        return this.warningDisplay;
    }

    @JsonProperty(value="warning_display")
    public void setWarningDisplay_JsonNullable(JsonNullable<String> warningDisplay) {
        this.warningDisplay = warningDisplay;
    }

    public void setWarningDisplay(String warningDisplay) {
        this.warningDisplay = JsonNullable.of((Object)warningDisplay);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSLOThreshold searchSloThreshold = (SearchSLOThreshold)o;
        return Objects.equals(this.target, searchSloThreshold.target) && Objects.equals(this.targetDisplay, searchSloThreshold.targetDisplay) && Objects.equals(this.timeframe, searchSloThreshold.timeframe) && Objects.equals(this.warning, searchSloThreshold.warning) && Objects.equals(this.warningDisplay, searchSloThreshold.warningDisplay);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.targetDisplay, this.timeframe, this.warning, this.warningDisplay);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchSLOThreshold {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    targetDisplay: ").append(this.toIndentedString(this.targetDisplay)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("    warning: ").append(this.toIndentedString(this.warning)).append("\n");
        sb.append("    warningDisplay: ").append(this.toIndentedString(this.warningDisplay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

