/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EventResponse;
import com.datadog.api.client.v2.model.EventsListResponseLinks;
import com.datadog.api.client.v2.model.EventsResponseMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "links", "meta"})
public class EventsListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<EventResponse> data = null;
    public static final String JSON_PROPERTY_LINKS = "links";
    private EventsListResponseLinks links;
    public static final String JSON_PROPERTY_META = "meta";
    private EventsResponseMetadata meta;

    public EventsListResponse data(List<EventResponse> data) {
        this.data = data;
        for (EventResponse item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EventsListResponse addDataItem(EventResponse dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<EventResponse>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventResponse> getData() {
        return this.data;
    }

    public void setData(List<EventResponse> data) {
        this.data = data;
    }

    public EventsListResponse links(EventsListResponseLinks links) {
        this.links = links;
        this.unparsed |= links.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsListResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(EventsListResponseLinks links) {
        this.links = links;
    }

    public EventsListResponse meta(EventsResponseMetadata meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsResponseMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(EventsResponseMetadata meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsListResponse eventsListResponse = (EventsListResponse)o;
        return Objects.equals(this.data, eventsListResponse.data) && Objects.equals(this.links, eventsListResponse.links) && Objects.equals(this.meta, eventsListResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

