/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.SecurityFilterCreateRequest;
import com.datadog.api.v2.client.model.SecurityFilterResponse;
import com.datadog.api.v2.client.model.SecurityFilterUpdateRequest;
import com.datadog.api.v2.client.model.SecurityFiltersResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringListRulesResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleCreatePayload;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleUpdatePayload;
import com.datadog.api.v2.client.model.SecurityMonitoringSignalListRequest;
import com.datadog.api.v2.client.model.SecurityMonitoringSignalsListResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringSignalsSort;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class SecurityMonitoringApi {
    private ApiClient apiClient;

    public SecurityMonitoringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecurityMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SecurityFilterResponse createSecurityFilter(SecurityFilterCreateRequest body) throws ApiException {
        return this.createSecurityFilterWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityFilterResponse> createSecurityFilterAsync(SecurityFilterCreateRequest body) {
        return this.createSecurityFilterWithHttpInfoAsync(body).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> createSecurityFilterWithHttpInfo(SecurityFilterCreateRequest body) throws ApiException {
        SecurityFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.createSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> createSecurityFilterWithHttpInfoAsync(SecurityFilterCreateRequest body) {
        Invocation.Builder builder;
        SecurityFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.createSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse createSecurityMonitoringRule(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        return this.createSecurityMonitoringRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleAsync(SecurityMonitoringRuleCreatePayload body) {
        return this.createSecurityMonitoringRuleWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> createSecurityMonitoringRuleWithHttpInfoAsync(SecurityMonitoringRuleCreatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public void deleteSecurityFilter(String securityFilterId) throws ApiException {
        this.deleteSecurityFilterWithHttpInfo(securityFilterId);
    }

    public CompletableFuture<Void> deleteSecurityFilterAsync(String securityFilterId) {
        return this.deleteSecurityFilterWithHttpInfoAsync(securityFilterId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityFilterWithHttpInfo(String securityFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling deleteSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.deleteSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityFilterWithHttpInfoAsync(String securityFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling deleteSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.deleteSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteSecurityMonitoringRule(String ruleId) throws ApiException {
        this.deleteSecurityMonitoringRuleWithHttpInfo(ruleId);
    }

    public CompletableFuture<Void> deleteSecurityMonitoringRuleAsync(String ruleId) {
        return this.deleteSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SecurityFilterResponse getSecurityFilter(String securityFilterId) throws ApiException {
        return this.getSecurityFilterWithHttpInfo(securityFilterId).getData();
    }

    public CompletableFuture<SecurityFilterResponse> getSecurityFilterAsync(String securityFilterId) {
        return this.getSecurityFilterWithHttpInfoAsync(securityFilterId).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> getSecurityFilterWithHttpInfo(String securityFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling getSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.getSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> getSecurityFilterWithHttpInfoAsync(String securityFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling getSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.getSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse getSecurityMonitoringRule(String ruleId) throws ApiException {
        return this.getSecurityMonitoringRuleWithHttpInfo(ruleId).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleAsync(String ruleId) {
        return this.getSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> getSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityFiltersResponse listSecurityFilters() throws ApiException {
        return this.listSecurityFiltersWithHttpInfo().getData();
    }

    public CompletableFuture<SecurityFiltersResponse> listSecurityFiltersAsync() {
        return this.listSecurityFiltersWithHttpInfoAsync().thenApply(response -> (SecurityFiltersResponse)response.getData());
    }

    public ApiResponse<SecurityFiltersResponse> listSecurityFiltersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.listSecurityFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFiltersResponse>> listSecurityFiltersWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.listSecurityFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFiltersResponse>> result = new CompletableFuture<ApiResponse<SecurityFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFiltersResponse>(){});
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules() throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(new ListSecurityMonitoringRulesOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesAsync() {
        return this.listSecurityMonitoringRulesWithHttpInfoAsync(new ListSecurityMonitoringRulesOptionalParameters()).thenApply(response -> (SecurityMonitoringListRulesResponse)response.getData());
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesAsync(ListSecurityMonitoringRulesOptionalParameters parameters) {
        return this.listSecurityMonitoringRulesWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringListRulesResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesWithHttpInfo(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringListRulesResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>> listSecurityMonitoringRulesWithHttpInfoAsync(ListSecurityMonitoringRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringListRulesResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals() throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(new ListSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsAsync() {
        return this.listSecurityMonitoringSignalsWithHttpInfoAsync(new ListSecurityMonitoringSignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsAsync(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        return this.listSecurityMonitoringSignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsWithHttpInfo(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> listSecurityMonitoringSignalsWithHttpInfoAsync(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals() throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(new SearchSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsAsync() {
        return this.searchSecurityMonitoringSignalsWithHttpInfoAsync(new SearchSecurityMonitoringSignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsAsync(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        return this.searchSecurityMonitoringSignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsWithHttpInfo(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> searchSecurityMonitoringSignalsWithHttpInfoAsync(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityFilterResponse updateSecurityFilter(String securityFilterId, SecurityFilterUpdateRequest body) throws ApiException {
        return this.updateSecurityFilterWithHttpInfo(securityFilterId, body).getData();
    }

    public CompletableFuture<SecurityFilterResponse> updateSecurityFilterAsync(String securityFilterId, SecurityFilterUpdateRequest body) {
        return this.updateSecurityFilterWithHttpInfoAsync(securityFilterId, body).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> updateSecurityFilterWithHttpInfo(String securityFilterId, SecurityFilterUpdateRequest body) throws ApiException {
        SecurityFilterUpdateRequest localVarPostBody = body;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling updateSecurityFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.updateSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> updateSecurityFilterWithHttpInfoAsync(String securityFilterId, SecurityFilterUpdateRequest body) {
        Invocation.Builder builder;
        SecurityFilterUpdateRequest localVarPostBody = body;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling updateSecurityFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.updateSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse updateSecurityMonitoringRule(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        return this.updateSecurityMonitoringRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleAsync(String ruleId, SecurityMonitoringRuleUpdatePayload body) {
        return this.updateSecurityMonitoringRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleWithHttpInfo(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> updateSecurityMonitoringRuleWithHttpInfoAsync(String ruleId, SecurityMonitoringRuleUpdatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public static class SearchSecurityMonitoringSignalsOptionalParameters {
        private SecurityMonitoringSignalListRequest body;

        public SearchSecurityMonitoringSignalsOptionalParameters body(SecurityMonitoringSignalListRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListSecurityMonitoringSignalsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private SecurityMonitoringSignalsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListSecurityMonitoringSignalsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters sort(SecurityMonitoringSignalsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListSecurityMonitoringRulesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListSecurityMonitoringRulesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListSecurityMonitoringRulesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

