/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageAttributionAggregatesBody;
import com.datadog.api.v1.client.model.UsageAttributionPagination;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"aggregates", "pagination"})
public class UsageAttributionMetadata {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATES = "aggregates";
    private List<UsageAttributionAggregatesBody> aggregates = null;
    public static final String JSON_PROPERTY_PAGINATION = "pagination";
    private UsageAttributionPagination pagination;

    public UsageAttributionMetadata aggregates(List<UsageAttributionAggregatesBody> aggregates) {
        this.aggregates = aggregates;
        for (UsageAttributionAggregatesBody item : aggregates) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsageAttributionMetadata addAggregatesItem(UsageAttributionAggregatesBody aggregatesItem) {
        if (this.aggregates == null) {
            this.aggregates = new ArrayList<UsageAttributionAggregatesBody>();
        }
        this.aggregates.add(aggregatesItem);
        this.unparsed |= aggregatesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageAttributionAggregatesBody> getAggregates() {
        return this.aggregates;
    }

    public void setAggregates(List<UsageAttributionAggregatesBody> aggregates) {
        this.aggregates = aggregates;
    }

    public UsageAttributionMetadata pagination(UsageAttributionPagination pagination) {
        this.pagination = pagination;
        this.unparsed |= pagination.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="pagination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageAttributionPagination getPagination() {
        return this.pagination;
    }

    public void setPagination(UsageAttributionPagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionMetadata usageAttributionMetadata = (UsageAttributionMetadata)o;
        return Objects.equals(this.aggregates, usageAttributionMetadata.aggregates) && Objects.equals(this.pagination, usageAttributionMetadata.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.aggregates, this.pagination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionMetadata {\n");
        sb.append("    aggregates: ").append(this.toIndentedString(this.aggregates)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

