/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsApiTestResultFailure;
import com.datadog.api.v1.client.model.SyntheticsSSLCertificate;
import com.datadog.api.v1.client.model.SyntheticsTestProcessStatus;
import com.datadog.api.v1.client.model.SyntheticsTiming;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"cert", "eventType", "failure", "httpStatusCode", "requestHeaders", "responseBody", "responseHeaders", "responseSize", "timings"})
public class SyntheticsAPITestResultData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CERT = "cert";
    private SyntheticsSSLCertificate cert;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private SyntheticsTestProcessStatus eventType;
    public static final String JSON_PROPERTY_FAILURE = "failure";
    private SyntheticsApiTestResultFailure failure;
    public static final String JSON_PROPERTY_HTTP_STATUS_CODE = "httpStatusCode";
    private Long httpStatusCode;
    public static final String JSON_PROPERTY_REQUEST_HEADERS = "requestHeaders";
    private Map<String, Object> requestHeaders = null;
    public static final String JSON_PROPERTY_RESPONSE_BODY = "responseBody";
    private String responseBody;
    public static final String JSON_PROPERTY_RESPONSE_HEADERS = "responseHeaders";
    private Map<String, Object> responseHeaders = null;
    public static final String JSON_PROPERTY_RESPONSE_SIZE = "responseSize";
    private Long responseSize;
    public static final String JSON_PROPERTY_TIMINGS = "timings";
    private SyntheticsTiming timings;

    public SyntheticsAPITestResultData cert(SyntheticsSSLCertificate cert) {
        this.cert = cert;
        this.unparsed |= cert.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="cert")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsSSLCertificate getCert() {
        return this.cert;
    }

    public void setCert(SyntheticsSSLCertificate cert) {
        this.cert = cert;
    }

    public SyntheticsAPITestResultData eventType(SyntheticsTestProcessStatus eventType) {
        this.eventType = eventType;
        this.unparsed |= !eventType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestProcessStatus getEventType() {
        return this.eventType;
    }

    public void setEventType(SyntheticsTestProcessStatus eventType) {
        if (!eventType.isValid()) {
            this.unparsed = true;
        }
        this.eventType = eventType;
    }

    public SyntheticsAPITestResultData failure(SyntheticsApiTestResultFailure failure) {
        this.failure = failure;
        this.unparsed |= failure.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsApiTestResultFailure getFailure() {
        return this.failure;
    }

    public void setFailure(SyntheticsApiTestResultFailure failure) {
        this.failure = failure;
    }

    public SyntheticsAPITestResultData httpStatusCode(Long httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="httpStatusCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(Long httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public SyntheticsAPITestResultData requestHeaders(Map<String, Object> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public SyntheticsAPITestResultData putRequestHeadersItem(String key, Object requestHeadersItem) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap<String, Object>();
        }
        this.requestHeaders.put(key, requestHeadersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="requestHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, Object> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public SyntheticsAPITestResultData responseBody(String responseBody) {
        this.responseBody = responseBody;
        return this;
    }

    @Nullable
    @JsonProperty(value="responseBody")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public SyntheticsAPITestResultData responseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
        return this;
    }

    public SyntheticsAPITestResultData putResponseHeadersItem(String key, Object responseHeadersItem) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new HashMap<String, Object>();
        }
        this.responseHeaders.put(key, responseHeadersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="responseHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public SyntheticsAPITestResultData responseSize(Long responseSize) {
        this.responseSize = responseSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="responseSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(Long responseSize) {
        this.responseSize = responseSize;
    }

    public SyntheticsAPITestResultData timings(SyntheticsTiming timings) {
        this.timings = timings;
        this.unparsed |= timings.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="timings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTiming getTimings() {
        return this.timings;
    }

    public void setTimings(SyntheticsTiming timings) {
        this.timings = timings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITestResultData syntheticsApiTestResultData = (SyntheticsAPITestResultData)o;
        return Objects.equals(this.cert, syntheticsApiTestResultData.cert) && Objects.equals(this.eventType, syntheticsApiTestResultData.eventType) && Objects.equals(this.failure, syntheticsApiTestResultData.failure) && Objects.equals(this.httpStatusCode, syntheticsApiTestResultData.httpStatusCode) && Objects.equals(this.requestHeaders, syntheticsApiTestResultData.requestHeaders) && Objects.equals(this.responseBody, syntheticsApiTestResultData.responseBody) && Objects.equals(this.responseHeaders, syntheticsApiTestResultData.responseHeaders) && Objects.equals(this.responseSize, syntheticsApiTestResultData.responseSize) && Objects.equals(this.timings, syntheticsApiTestResultData.timings);
    }

    public int hashCode() {
        return Objects.hash(this.cert, this.eventType, this.failure, this.httpStatusCode, this.requestHeaders, this.responseBody, this.responseHeaders, this.responseSize, this.timings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITestResultData {\n");
        sb.append("    cert: ").append(this.toIndentedString(this.cert)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    failure: ").append(this.toIndentedString(this.failure)).append("\n");
        sb.append("    httpStatusCode: ").append(this.toIndentedString(this.httpStatusCode)).append("\n");
        sb.append("    requestHeaders: ").append(this.toIndentedString(this.requestHeaders)).append("\n");
        sb.append("    responseBody: ").append(this.toIndentedString(this.responseBody)).append("\n");
        sb.append("    responseHeaders: ").append(this.toIndentedString(this.responseHeaders)).append("\n");
        sb.append("    responseSize: ").append(this.toIndentedString(this.responseSize)).append("\n");
        sb.append("    timings: ").append(this.toIndentedString(this.timings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

