/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.JsonTimeSerializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"from", "timezone", "to"})
public class LogsListRequestTime {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FROM = "from";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime from;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;
    public static final String JSON_PROPERTY_TO = "to";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime to;

    public LogsListRequestTime() {
    }

    @JsonCreator
    public LogsListRequestTime(@JsonProperty(required=true, value="from") OffsetDateTime from, @JsonProperty(required=true, value="to") OffsetDateTime to) {
        this.from = from;
        this.to = to;
    }

    public LogsListRequestTime from(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getFrom() {
        return this.from;
    }

    public void setFrom(OffsetDateTime from) {
        this.from = from;
    }

    public LogsListRequestTime timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public LogsListRequestTime to(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getTo() {
        return this.to;
    }

    public void setTo(OffsetDateTime to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListRequestTime logsListRequestTime = (LogsListRequestTime)o;
        return Objects.equals(this.from, logsListRequestTime.from) && Objects.equals(this.timezone, logsListRequestTime.timezone) && Objects.equals(this.to, logsListRequestTime.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.timezone, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListRequestTime {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

