/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.AddSignalToIncidentRequest;
import com.datadog.api.v1.client.model.SignalAssigneeUpdateRequest;
import com.datadog.api.v1.client.model.SignalStateUpdateRequest;
import com.datadog.api.v1.client.model.SuccessfulSignalUpdateResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class SecurityMonitoringApi {
    private ApiClient apiClient;

    public SecurityMonitoringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecurityMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SuccessfulSignalUpdateResponse addSecurityMonitoringSignalToIncident(String signalId, AddSignalToIncidentRequest body) throws ApiException {
        return this.addSecurityMonitoringSignalToIncidentWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SuccessfulSignalUpdateResponse> addSecurityMonitoringSignalToIncidentAsync(String signalId, AddSignalToIncidentRequest body) {
        return this.addSecurityMonitoringSignalToIncidentWithHttpInfoAsync(signalId, body).thenApply(response -> (SuccessfulSignalUpdateResponse)response.getData());
    }

    public ApiResponse<SuccessfulSignalUpdateResponse> addSecurityMonitoringSignalToIncidentWithHttpInfo(String signalId, AddSignalToIncidentRequest body) throws ApiException {
        AddSignalToIncidentRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling addSecurityMonitoringSignalToIncident");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addSecurityMonitoringSignalToIncident");
        }
        String localVarPath = "/api/v1/security_analytics/signals/{signal_id}/add_to_incident".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.addSecurityMonitoringSignalToIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SuccessfulSignalUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> addSecurityMonitoringSignalToIncidentWithHttpInfoAsync(String signalId, AddSignalToIncidentRequest body) {
        Invocation.Builder builder;
        AddSignalToIncidentRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling addSecurityMonitoringSignalToIncident"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling addSecurityMonitoringSignalToIncident"));
            return result;
        }
        String localVarPath = "/api/v1/security_analytics/signals/{signal_id}/add_to_incident".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.addSecurityMonitoringSignalToIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SuccessfulSignalUpdateResponse>(){});
    }

    public SuccessfulSignalUpdateResponse editSecurityMonitoringSignalAssignee(String signalId, SignalAssigneeUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalAssigneeWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SuccessfulSignalUpdateResponse> editSecurityMonitoringSignalAssigneeAsync(String signalId, SignalAssigneeUpdateRequest body) {
        return this.editSecurityMonitoringSignalAssigneeWithHttpInfoAsync(signalId, body).thenApply(response -> (SuccessfulSignalUpdateResponse)response.getData());
    }

    public ApiResponse<SuccessfulSignalUpdateResponse> editSecurityMonitoringSignalAssigneeWithHttpInfo(String signalId, SignalAssigneeUpdateRequest body) throws ApiException {
        SignalAssigneeUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalAssignee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalAssignee");
        }
        String localVarPath = "/api/v1/security_analytics/signals/{signal_id}/assignee".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.editSecurityMonitoringSignalAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SuccessfulSignalUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> editSecurityMonitoringSignalAssigneeWithHttpInfoAsync(String signalId, SignalAssigneeUpdateRequest body) {
        Invocation.Builder builder;
        SignalAssigneeUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalAssignee"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalAssignee"));
            return result;
        }
        String localVarPath = "/api/v1/security_analytics/signals/{signal_id}/assignee".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.editSecurityMonitoringSignalAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SuccessfulSignalUpdateResponse>(){});
    }

    public SuccessfulSignalUpdateResponse editSecurityMonitoringSignalState(String signalId, SignalStateUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalStateWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SuccessfulSignalUpdateResponse> editSecurityMonitoringSignalStateAsync(String signalId, SignalStateUpdateRequest body) {
        return this.editSecurityMonitoringSignalStateWithHttpInfoAsync(signalId, body).thenApply(response -> (SuccessfulSignalUpdateResponse)response.getData());
    }

    public ApiResponse<SuccessfulSignalUpdateResponse> editSecurityMonitoringSignalStateWithHttpInfo(String signalId, SignalStateUpdateRequest body) throws ApiException {
        SignalStateUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalState");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalState");
        }
        String localVarPath = "/api/v1/security_analytics/signals/{signal_id}/state".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("SecurityMonitoringApi.editSecurityMonitoringSignalState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SuccessfulSignalUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> editSecurityMonitoringSignalStateWithHttpInfoAsync(String signalId, SignalStateUpdateRequest body) {
        Invocation.Builder builder;
        SignalStateUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalState"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalState"));
            return result;
        }
        String localVarPath = "/api/v1/security_analytics/signals/{signal_id}/state".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("SecurityMonitoringApi.editSecurityMonitoringSignalState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>> result = new CompletableFuture<ApiResponse<SuccessfulSignalUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SuccessfulSignalUpdateResponse>(){});
    }
}

