/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.AuthNMappingAttributes;
import com.datadog.api.v2.client.model.AuthNMappingIncluded;
import com.datadog.api.v2.client.model.AuthNMappingRelationships;
import com.datadog.api.v2.client.model.AuthNMappingsType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"attributes", "id", "included", "relationships", "type"})
public class AuthNMapping {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private AuthNMappingAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<AuthNMappingIncluded> included = null;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private AuthNMappingRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AuthNMappingsType type = AuthNMappingsType.AUTHN_MAPPINGS;

    public AuthNMapping() {
    }

    @JsonCreator
    public AuthNMapping(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") AuthNMappingsType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AuthNMapping attributes(AuthNMappingAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthNMappingAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AuthNMappingAttributes attributes) {
        this.attributes = attributes;
    }

    public AuthNMapping id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuthNMapping included(List<AuthNMappingIncluded> included) {
        this.included = included;
        for (AuthNMappingIncluded item : included) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AuthNMapping addIncludedItem(AuthNMappingIncluded includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<AuthNMappingIncluded>();
        }
        this.included.add(includedItem);
        this.unparsed |= includedItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthNMappingIncluded> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<AuthNMappingIncluded> included) {
        this.included = included;
    }

    public AuthNMapping relationships(AuthNMappingRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthNMappingRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(AuthNMappingRelationships relationships) {
        this.relationships = relationships;
    }

    public AuthNMapping type(AuthNMappingsType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AuthNMappingsType getType() {
        return this.type;
    }

    public void setType(AuthNMappingsType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthNMapping authNMapping = (AuthNMapping)o;
        return Objects.equals(this.attributes, authNMapping.attributes) && Objects.equals(this.id, authNMapping.id) && Objects.equals(this.included, authNMapping.included) && Objects.equals(this.relationships, authNMapping.relationships) && Objects.equals(this.type, authNMapping.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.included, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthNMapping {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

