/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentCreateRequest;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentResponse;
import com.datadog.api.v2.client.model.IncidentUpdateRequest;
import com.datadog.api.v2.client.model.IncidentsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class IncidentsApi {
    private ApiClient apiClient;

    public IncidentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentResponse createIncident(IncidentCreateRequest body) throws ApiException {
        return this.createIncidentWithHttpInfo(body).getData();
    }

    public CompletableFuture<IncidentResponse> createIncidentAsync(IncidentCreateRequest body) {
        return this.createIncidentWithHttpInfoAsync(body).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> createIncidentWithHttpInfo(IncidentCreateRequest body) throws ApiException {
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncident");
        }
        String localVarPath = "/api/v2/incidents";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("IncidentsApi.createIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> createIncidentWithHttpInfoAsync(IncidentCreateRequest body) {
        Invocation.Builder builder;
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createIncident"));
            return result;
        }
        String localVarPath = "/api/v2/incidents";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("IncidentsApi.createIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public void deleteIncident(String incidentId) throws ApiException {
        this.deleteIncidentWithHttpInfo(incidentId);
    }

    public CompletableFuture<Void> deleteIncidentAsync(String incidentId) {
        return this.deleteIncidentWithHttpInfoAsync(incidentId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteIncidentWithHttpInfo(String incidentId) throws ApiException {
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("IncidentsApi.deleteIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteIncidentWithHttpInfoAsync(String incidentId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident"));
            return result;
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("IncidentsApi.deleteIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public IncidentResponse getIncident(String incidentId) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, new GetIncidentOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentResponse> getIncidentAsync(String incidentId) {
        return this.getIncidentWithHttpInfoAsync(incidentId, new GetIncidentOptionalParameters()).thenApply(response -> (IncidentResponse)response.getData());
    }

    public IncidentResponse getIncident(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, parameters).getData();
    }

    public CompletableFuture<IncidentResponse> getIncidentAsync(String incidentId, GetIncidentOptionalParameters parameters) {
        return this.getIncidentWithHttpInfoAsync(incidentId, parameters).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> getIncidentWithHttpInfo(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("IncidentsApi.getIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> getIncidentWithHttpInfoAsync(String incidentId, GetIncidentOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("IncidentsApi.getIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public IncidentsResponse listIncidents() throws ApiException {
        return this.listIncidentsWithHttpInfo(new ListIncidentsOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentsResponse> listIncidentsAsync() {
        return this.listIncidentsWithHttpInfoAsync(new ListIncidentsOptionalParameters()).thenApply(response -> (IncidentsResponse)response.getData());
    }

    public IncidentsResponse listIncidents(ListIncidentsOptionalParameters parameters) throws ApiException {
        return this.listIncidentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<IncidentsResponse> listIncidentsAsync(ListIncidentsOptionalParameters parameters) {
        return this.listIncidentsWithHttpInfoAsync(parameters).thenApply(response -> (IncidentsResponse)response.getData());
    }

    public ApiResponse<IncidentsResponse> listIncidentsWithHttpInfo(ListIncidentsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("IncidentsApi.listIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentsResponse>> listIncidentsWithHttpInfoAsync(ListIncidentsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        try {
            builder = this.apiClient.createBuilder("IncidentsApi.listIncidents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentsResponse>> result = new CompletableFuture<ApiResponse<IncidentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentsResponse>(){});
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body, new UpdateIncidentOptionalParameters()).getData();
    }

    public CompletableFuture<IncidentResponse> updateIncidentAsync(String incidentId, IncidentUpdateRequest body) {
        return this.updateIncidentWithHttpInfoAsync(incidentId, body, new UpdateIncidentOptionalParameters()).thenApply(response -> (IncidentResponse)response.getData());
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body, parameters).getData();
    }

    public CompletableFuture<IncidentResponse> updateIncidentAsync(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) {
        return this.updateIncidentWithHttpInfoAsync(incidentId, body, parameters).thenApply(response -> (IncidentResponse)response.getData());
    }

    public ApiResponse<IncidentResponse> updateIncidentWithHttpInfo(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) throws ApiException {
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("IncidentsApi.updateIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<IncidentResponse>> updateIncidentWithHttpInfoAsync(String incidentId, IncidentUpdateRequest body, UpdateIncidentOptionalParameters parameters) {
        Invocation.Builder builder;
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateIncident"));
            return result;
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        try {
            builder = this.apiClient.createBuilder("IncidentsApi.updateIncident", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IncidentResponse>> result = new CompletableFuture<ApiResponse<IncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IncidentResponse>(){});
    }

    public static class UpdateIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public UpdateIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }

    public static class ListIncidentsOptionalParameters {
        private List<IncidentRelatedObject> include;
        private Long pageSize;
        private Long pageOffset;

        public ListIncidentsOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public ListIncidentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class GetIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public GetIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }
}

