/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.AuditLogsEventsResponse;
import com.datadog.api.v2.client.model.AuditLogsSearchEventsRequest;
import com.datadog.api.v2.client.model.AuditLogsSort;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class AuditApi {
    private ApiClient apiClient;

    public AuditApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuditApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuditLogsEventsResponse listAuditLogs() throws ApiException {
        return this.listAuditLogsWithHttpInfo(new ListAuditLogsOptionalParameters()).getData();
    }

    public CompletableFuture<AuditLogsEventsResponse> listAuditLogsAsync() {
        return this.listAuditLogsWithHttpInfoAsync(new ListAuditLogsOptionalParameters()).thenApply(response -> (AuditLogsEventsResponse)response.getData());
    }

    public AuditLogsEventsResponse listAuditLogs(ListAuditLogsOptionalParameters parameters) throws ApiException {
        return this.listAuditLogsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<AuditLogsEventsResponse> listAuditLogsAsync(ListAuditLogsOptionalParameters parameters) {
        return this.listAuditLogsWithHttpInfoAsync(parameters).thenApply(response -> (AuditLogsEventsResponse)response.getData());
    }

    public ApiResponse<AuditLogsEventsResponse> listAuditLogsWithHttpInfo(ListAuditLogsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        AuditLogsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/audit/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("AuditApi.listAuditLogs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuditLogsEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AuditLogsEventsResponse>> listAuditLogsWithHttpInfoAsync(ListAuditLogsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        AuditLogsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/audit/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("AuditApi.listAuditLogs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AuditLogsEventsResponse>> result = new CompletableFuture<ApiResponse<AuditLogsEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuditLogsEventsResponse>(){});
    }

    public AuditLogsEventsResponse searchAuditLogs() throws ApiException {
        return this.searchAuditLogsWithHttpInfo(new SearchAuditLogsOptionalParameters()).getData();
    }

    public CompletableFuture<AuditLogsEventsResponse> searchAuditLogsAsync() {
        return this.searchAuditLogsWithHttpInfoAsync(new SearchAuditLogsOptionalParameters()).thenApply(response -> (AuditLogsEventsResponse)response.getData());
    }

    public AuditLogsEventsResponse searchAuditLogs(SearchAuditLogsOptionalParameters parameters) throws ApiException {
        return this.searchAuditLogsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<AuditLogsEventsResponse> searchAuditLogsAsync(SearchAuditLogsOptionalParameters parameters) {
        return this.searchAuditLogsWithHttpInfoAsync(parameters).thenApply(response -> (AuditLogsEventsResponse)response.getData());
    }

    public ApiResponse<AuditLogsEventsResponse> searchAuditLogsWithHttpInfo(SearchAuditLogsOptionalParameters parameters) throws ApiException {
        AuditLogsSearchEventsRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/audit/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("AuditApi.searchAuditLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuditLogsEventsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AuditLogsEventsResponse>> searchAuditLogsWithHttpInfoAsync(SearchAuditLogsOptionalParameters parameters) {
        Invocation.Builder builder;
        AuditLogsSearchEventsRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/audit/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("AuditApi.searchAuditLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AuditLogsEventsResponse>> result = new CompletableFuture<ApiResponse<AuditLogsEventsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuditLogsEventsResponse>(){});
    }

    public static class SearchAuditLogsOptionalParameters {
        private AuditLogsSearchEventsRequest body;

        public SearchAuditLogsOptionalParameters body(AuditLogsSearchEventsRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListAuditLogsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private AuditLogsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListAuditLogsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListAuditLogsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListAuditLogsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListAuditLogsOptionalParameters sort(AuditLogsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListAuditLogsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListAuditLogsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }
}

