/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=WidgetAggregatorSerializer.class)
public class WidgetAggregator {
    public static final WidgetAggregator AVERAGE = new WidgetAggregator("avg");
    public static final WidgetAggregator LAST = new WidgetAggregator("last");
    public static final WidgetAggregator MAXIMUM = new WidgetAggregator("max");
    public static final WidgetAggregator MINIMUM = new WidgetAggregator("min");
    public static final WidgetAggregator SUM = new WidgetAggregator("sum");
    public static final WidgetAggregator PERCENTILE = new WidgetAggregator("percentile");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("avg", "last", "max", "min", "sum", "percentile"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    WidgetAggregator(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((WidgetAggregator)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static WidgetAggregator fromValue(String value) {
        return new WidgetAggregator(value);
    }

    public static class WidgetAggregatorSerializer
    extends StdSerializer<WidgetAggregator> {
        public WidgetAggregatorSerializer(Class<WidgetAggregator> t) {
            super(t);
        }

        public WidgetAggregatorSerializer() {
            this(null);
        }

        public void serialize(WidgetAggregator value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

