/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"filter_by", "limit", "metric", "search_by"})
public class ProcessQueryDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER_BY = "filter_by";
    private List<String> filterBy = null;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Long limit;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_SEARCH_BY = "search_by";
    private String searchBy;

    public ProcessQueryDefinition() {
    }

    @JsonCreator
    public ProcessQueryDefinition(@JsonProperty(required=true, value="metric") String metric) {
        this.metric = metric;
    }

    public ProcessQueryDefinition filterBy(List<String> filterBy) {
        this.filterBy = filterBy;
        return this;
    }

    public ProcessQueryDefinition addFilterByItem(String filterByItem) {
        if (this.filterBy == null) {
            this.filterBy = new ArrayList<String>();
        }
        this.filterBy.add(filterByItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="filter_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(List<String> filterBy) {
        this.filterBy = filterBy;
    }

    public ProcessQueryDefinition limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public ProcessQueryDefinition metric(String metric) {
        this.metric = metric;
        return this;
    }

    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public ProcessQueryDefinition searchBy(String searchBy) {
        this.searchBy = searchBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="search_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSearchBy() {
        return this.searchBy;
    }

    public void setSearchBy(String searchBy) {
        this.searchBy = searchBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessQueryDefinition processQueryDefinition = (ProcessQueryDefinition)o;
        return Objects.equals(this.filterBy, processQueryDefinition.filterBy) && Objects.equals(this.limit, processQueryDefinition.limit) && Objects.equals(this.metric, processQueryDefinition.metric) && Objects.equals(this.searchBy, processQueryDefinition.searchBy);
    }

    public int hashCode() {
        return Objects.hash(this.filterBy, this.limit, this.metric, this.searchBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessQueryDefinition {\n");
        sb.append("    filterBy: ").append(this.toIndentedString(this.filterBy)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    searchBy: ").append(this.toIndentedString(this.searchBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

